/*
 * Decompiled with CFR 0.152.
 */
package net.apexes.commons.eventbus;

import java.lang.reflect.Method;
import net.apexes.commons.eventbus.AnnotationPriority;
import net.apexes.commons.eventbus.EventFilter;
import net.apexes.commons.eventbus.EventFilterChain;
import net.apexes.commons.eventbus.IEventFilter;

class AnnotationEventFilter
extends AnnotationPriority
implements IEventFilter<Object> {
    private final String address;
    private final int priority;

    AnnotationEventFilter(Object invokedObject, Method method) {
        super(invokedObject, method);
        EventFilter annotation = method.getAnnotation(EventFilter.class);
        this.priority = annotation.priority();
        if (annotation.address() == null || annotation.address().isEmpty()) {
            Class<?> paramType = method.getParameterTypes()[0];
            this.address = paramType.getName();
        } else {
            this.address = annotation.address();
        }
    }

    @Override
    public void filter(Object event, EventFilterChain<Object> chain) {
        Class<?>[] parameterTypes = this.invokedMethod.getParameterTypes();
        if (parameterTypes.length != 2) {
            throw new RuntimeException("The method is invalid. method=" + this.invokedMethod);
        }
        try {
            this.invokedMethod.invoke(this.invokedObject, event, chain);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    protected String getAddress() {
        return this.address;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }
}

