/*
 * Decompiled with CFR 0.152.
 */
package net.apexes.commons.eventbus;

import java.lang.reflect.Method;
import net.apexes.commons.eventbus.AnnotationPriority;
import net.apexes.commons.eventbus.IEventHandler;
import net.apexes.commons.eventbus.Subscribe;

class AnnotationEventHandler
extends AnnotationPriority
implements IEventHandler<Object> {
    private final String address;
    private final int priority;

    AnnotationEventHandler(Object invokedObject, Method method) {
        super(invokedObject, method);
        Subscribe annotation = method.getAnnotation(Subscribe.class);
        this.priority = annotation.priority();
        if (annotation.address() == null || annotation.address().isEmpty()) {
            Class<?> paramType = method.getParameterTypes()[0];
            this.address = paramType.getName();
        } else {
            this.address = annotation.address();
        }
    }

    @Override
    public void handle(Object event) {
        Class<?>[] parameterTypes = this.invokedMethod.getParameterTypes();
        if (parameterTypes.length != 1) {
            throw new RuntimeException("The method is invalid. method=" + this.invokedMethod);
        }
        try {
            this.invokedMethod.invoke(this.invokedObject, event);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    protected String getAddress() {
        return this.address;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }
}

