/*
 * Decompiled with CFR 0.152.
 */
package net.apexes.commons.eventbus;

import java.lang.reflect.Method;
import java.util.LinkedHashSet;
import java.util.Set;
import net.apexes.commons.eventbus.AnnotationEventHandler;
import net.apexes.commons.eventbus.AnnotationPriority;
import net.apexes.commons.eventbus.IEventHandler;
import net.apexes.commons.eventbus.IPriority;
import net.apexes.commons.eventbus.PriorityHub;
import net.apexes.commons.eventbus.PriorityList;
import net.apexes.commons.eventbus.Subscribe;

public class EventBus
extends PriorityHub {
    public EventBus() {
        super(IEventHandler.class);
    }

    public <T> void register(String address, IEventHandler<T> handler) {
        EventBus.verifyNotNull(address, "address");
        EventBus.verifyNotNull(handler, "handler");
        super.register(address, handler);
    }

    public <T> void unregister(String address, IEventHandler<T> handler) {
        EventBus.verifyNotNull(address, "address");
        EventBus.verifyNotNull(handler, "handler");
        super.unregister(address, handler);
    }

    @Override
    protected Set<AnnotationPriority> getAnnotationPrioritys(Object object) {
        Method[] methods;
        LinkedHashSet<AnnotationPriority> handlers = new LinkedHashSet<AnnotationPriority>();
        Class<?> clazz = object.getClass();
        for (Method method : methods = clazz.getDeclaredMethods()) {
            if (!method.isAnnotationPresent(Subscribe.class)) continue;
            Class<?>[] parameterTypes = method.getParameterTypes();
            if (parameterTypes.length != 1) {
                throw new IllegalArgumentException("The method is invalid. method=" + method);
            }
            AnnotationEventHandler handler = new AnnotationEventHandler(object, method);
            handlers.add(handler);
        }
        return handlers;
    }

    @Override
    protected <E> void doPost(String address, E event, PriorityList<E> prioritys) {
        for (IPriority iPriority : prioritys) {
            IEventHandler handler = (IEventHandler)iPriority;
            handler.handle(event);
        }
    }
}

