/*
 * Decompiled with CFR 0.152.
 */
package net.apexes.commons.eventbus;

import net.apexes.commons.eventbus.EventBus;
import net.apexes.commons.eventbus.EventBusFilter;
import net.apexes.commons.eventbus.IEventHandler;
import net.apexes.commons.eventbus.IPublisher;
import net.apexes.commons.eventbus.PriorityHub;

public class FilterableEventBus {
    private final EventBus eventBus = new EventBus();
    private final EventBusFilter eventBusFilter = new EventBusFilter(new IPublisher(){

        public <T> void publish(String address, T event) {
            FilterableEventBus.this.eventBus.post(address, event);
        }
    });

    public void register(Object object) {
        this.eventBusFilter.register(object);
        this.eventBus.register(object);
    }

    public <T> void register(String address, IEventHandler<T> handler) {
        ((PriorityHub)this.eventBusFilter).register(address, handler);
        this.eventBus.register(address, handler);
    }

    public void unregister(Object object) {
        this.eventBus.unregister(object);
        this.eventBusFilter.unregister(object);
    }

    public <T> void unregister(String address, IEventHandler<T> handler) {
        this.eventBus.unregister(address, handler);
        ((PriorityHub)this.eventBusFilter).unregister(address, handler);
    }

    public void post(Object event) {
        this.eventBusFilter.post(event);
    }

    public <E> void post(String address, E event) {
        this.eventBusFilter.post(address, (Object)event);
    }
}

