/*
 * Decompiled with CFR 0.152.
 */
package net.apexes.commons.json.fastjson;

import com.alibaba.fastjson.parser.ParserConfig;
import com.alibaba.fastjson.serializer.SerializeConfig;
import net.apexes.commons.json.fastjson.EnumeByIntegerDeserializer;
import net.apexes.commons.json.fastjson.EnumeByIntegerSerializer;
import net.apexes.commons.json.fastjson.EnumeByStringDeserializer;
import net.apexes.commons.json.fastjson.EnumeByStringSerializer;
import net.apexes.commons.lang.Enume;
import net.apexes.commons.lang.EnumeRegistry;

public final class Fastjsons {
    private Fastjsons() {
    }

    public static void register(SerializeConfig serializeConfig, ParserConfig parserConfig, EnumeRegistry enumeRegistry) {
        for (Class enumeClass : enumeRegistry.getEnumeClasses()) {
            Fastjsons.register(serializeConfig, parserConfig, enumeClass);
        }
    }

    public static void register(SerializeConfig serializeConfig, ParserConfig parserConfig, Class<? extends Enume<?>> enumeClass) {
        Class valueClass = Enume.valueClass(enumeClass);
        if (valueClass == String.class) {
            Class<? extends Enume<?>> classType = enumeClass;
            serializeConfig.put(classType, new EnumeByStringSerializer());
            parserConfig.putDeserializer(classType, new EnumeByStringDeserializer(classType));
        } else if (valueClass == Integer.class) {
            Class<? extends Enume<?>> classType = enumeClass;
            serializeConfig.put(classType, new EnumeByIntegerSerializer());
            parserConfig.putDeserializer(classType, new EnumeByIntegerDeserializer(classType));
        }
    }
}

