/*
 * Decompiled with CFR 0.152.
 */
package net.apexes.commons.json.gson;

import com.google.gson.Gson;
import java.lang.reflect.Type;
import net.apexes.commons.lang.Checks;
import net.apexes.commons.net.JsonHttpCaller;

public final class GsonHttps {
    private GsonHttps() {
    }

    public static JsonHttpCaller.JsonEncoder createEncoder() {
        return GsonHttps.createEncoder(null);
    }

    public static JsonHttpCaller.JsonEncoder createEncoder(Gson gson) {
        return new GsonEncoder(gson);
    }

    public static <R> JsonHttpCaller.JsonDecoder<R> createDecoder(Type returnType) {
        return GsonHttps.createDecoder(null, returnType);
    }

    public static <R> JsonHttpCaller.JsonDecoder<R> createDecoder(Gson gson, Type returnType) {
        return new GsonDecoder(gson, returnType);
    }

    public static JsonHttpCaller.JsonHttpNoticer forNotice(String url) {
        return GsonHttps.forNotice(url, GsonHttps.createEncoder());
    }

    public static JsonHttpCaller.JsonHttpNoticer forNotice(String url, JsonHttpCaller.JsonEncoder encoder) {
        return JsonHttpCaller.forNotice((String)url, (JsonHttpCaller.JsonEncoder)encoder);
    }

    public static <R> JsonHttpCaller<R> forRequest(String url, Type returnType) {
        return GsonHttps.forRequest(url, null, returnType);
    }

    public static <R> JsonHttpCaller<R> forRequest(String url, Gson gson, Type returnType) {
        JsonHttpCaller.JsonEncoder encoder = GsonHttps.createEncoder(gson);
        JsonHttpCaller.JsonDecoder<R> decoder = GsonHttps.createDecoder(gson, returnType);
        return JsonHttpCaller.forRequest((String)url, (JsonHttpCaller.JsonEncoder)encoder, decoder);
    }

    public static <R> JsonHttpCaller<R> forRequest(String url, JsonHttpCaller.JsonDecoder<R> decoder) {
        JsonHttpCaller.JsonEncoder encoder = GsonHttps.createEncoder();
        return JsonHttpCaller.forRequest((String)url, (JsonHttpCaller.JsonEncoder)encoder, decoder);
    }

    private static class GsonDecoder<R>
    implements JsonHttpCaller.JsonDecoder<R> {
        private final Gson gson;
        private final Type returnType;

        GsonDecoder(Gson gson, Type returnType) {
            Checks.verifyNotNull((Object)returnType, (String)"returnType");
            this.gson = gson != null ? gson : new Gson();
            this.returnType = returnType;
        }

        public R fromJson(String json) throws Exception {
            return (R)this.gson.fromJson(json, this.returnType);
        }
    }

    private static class GsonEncoder
    implements JsonHttpCaller.JsonEncoder {
        private final Gson gson;

        GsonEncoder(Gson gson) {
            this.gson = gson != null ? gson : new Gson();
        }

        public String toJson(Object object) throws Exception {
            return this.gson.toJson(object);
        }
    }
}

