/*
 * Decompiled with CFR 0.152.
 */
package net.apexes.commons.json.gson;

import com.google.gson.GsonBuilder;
import java.util.Collection;
import net.apexes.commons.json.gson.EnumeByIntegerAdapter;
import net.apexes.commons.json.gson.EnumeByStringAdapter;
import net.apexes.commons.lang.Enume;
import net.apexes.commons.lang.EnumeRegistry;

public final class Gsons {
    private Gsons() {
    }

    public static GsonBuilder createModule(EnumeRegistry enumeRegistry) {
        return Gsons.createGsonBuilder(enumeRegistry.getEnumeClasses());
    }

    public static GsonBuilder createGsonBuilder(Collection<Class<? extends Enume<?>>> enumeClasses) {
        return Gsons.registerGsonBuilder(new GsonBuilder(), enumeClasses);
    }

    public static GsonBuilder registerGsonBuilder(GsonBuilder gsonBuilder, EnumeRegistry enumeRegistry) {
        return Gsons.registerGsonBuilder(gsonBuilder, enumeRegistry.getEnumeClasses());
    }

    public static GsonBuilder registerGsonBuilder(GsonBuilder gsonBuilder, Collection<Class<? extends Enume<?>>> enumeClasses) {
        for (Class<Enume<?>> clazz : enumeClasses) {
            Gsons.registerModule(gsonBuilder, clazz);
        }
        return gsonBuilder;
    }

    public static GsonBuilder registerModule(GsonBuilder gsonBuilder, Class<? extends Enume<?>> enumeClass) {
        Class valueClass = Enume.valueClass(enumeClass);
        if (valueClass == String.class) {
            Class<? extends Enume<?>> classType = enumeClass;
            gsonBuilder.registerTypeAdapter(classType, new EnumeByStringAdapter(classType));
        } else if (valueClass == Integer.class) {
            Class<? extends Enume<?>> classType = enumeClass;
            gsonBuilder.registerTypeAdapter(classType, new EnumeByIntegerAdapter(classType));
        }
        return gsonBuilder;
    }
}

