/*
 * Decompiled with CFR 0.152.
 */
package net.apexes.commons.json.jackson;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class AdaptiveDateJsonDeserializer
extends JsonDeserializer<Date> {
    public static final String DEFAULT_DATE_FORMAT = "yyyy-MM-dd";
    public static final String DEFAULT_DATETIME_FORMAT = "yyyy-MM-dd HH:mm:ss";
    public static final String ISO8601_DATE_WITHOUT_ZONE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss";

    public Date deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        String dateStr;
        String temp = dateStr = jp.getText();
        if (dateStr == null || dateStr.isEmpty()) {
            return null;
        }
        String fm = null;
        if (dateStr.contains(":")) {
            if (dateStr.contains("T")) {
                fm = ISO8601_DATE_WITHOUT_ZONE_FORMAT;
            } else if (dateStr.contains(":")) {
                fm = DEFAULT_DATETIME_FORMAT;
            }
        } else if (dateStr.indexOf(45) > 1) {
            fm = DEFAULT_DATE_FORMAT;
        }
        try {
            if (fm != null) {
                return new SimpleDateFormat(fm).parse(dateStr);
            }
            return new Date(Long.parseLong(dateStr));
        }
        catch (ParseException e) {
            throw new JsonDateParseException(temp, e);
        }
    }

    public static class JsonDateParseException
    extends JsonProcessingException {
        private static final long serialVersionUID = 1L;

        protected JsonDateParseException(String msg, Throwable rootCause) {
            super(msg, rootCause);
        }
    }
}

