/*
 * Decompiled with CFR 0.152.
 */
package net.apexes.commons.json.jackson;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.CollectionLikeType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.util.List;
import net.apexes.commons.lang.Checks;
import net.apexes.commons.net.JsonHttpCaller;

public final class JacksonHttps {
    public static final ObjectMapper DEFAULT_OBJECT_MAPPER = JacksonHttps.createObjectMapper();

    private JacksonHttps() {
    }

    public static JsonHttpCaller.JsonEncoder createEncoder() {
        return JacksonHttps.createEncoder(null);
    }

    public static JsonHttpCaller.JsonEncoder createEncoder(ObjectMapper objectMapper) {
        return new JacksonEncoder(objectMapper);
    }

    public static <R> JsonHttpCaller.JsonDecoder<R> createDecoder(Class<R> returnClass) {
        return JacksonHttps.createDecoder(null, returnClass);
    }

    public static <R> JsonHttpCaller.JsonDecoder<R> createDecoder(ObjectMapper objectMapper, Class<R> returnClass) {
        return new JacksonDecoder<R>(objectMapper, returnClass);
    }

    public static <R> JsonHttpCaller.JsonDecoder<R> createDecoder(JavaType javaType) {
        return JacksonHttps.createDecoder(null, javaType);
    }

    public static <R> JsonHttpCaller.JsonDecoder<R> createDecoder(ObjectMapper objectMapper, JavaType javaType) {
        return new JacksonDecoder(objectMapper, javaType);
    }

    public static <R> JsonHttpCaller.JsonDecoder<R> createDecoder(ObjectMapper objectMapper, TypeReference<R> typeRef) {
        return new JacksonTypeReferenceDecoder<R>(objectMapper, typeRef);
    }

    public static JsonHttpCaller.JsonHttpNoticer forNotice(String url) {
        return JacksonHttps.forNotice(url, JacksonHttps.createEncoder());
    }

    public static JsonHttpCaller.JsonHttpNoticer forNotice(String url, JsonHttpCaller.JsonEncoder encoder) {
        return JsonHttpCaller.forNotice((String)url, (JsonHttpCaller.JsonEncoder)encoder);
    }

    public static <R> JsonHttpCaller<R> forRequest(String url, Class<R> returnClass) {
        return JacksonHttps.forRequest(url, null, returnClass);
    }

    public static <R> JsonHttpCaller<R> forRequest(String url, ObjectMapper objectMapper, Class<R> returnClass) {
        JsonHttpCaller.JsonEncoder encoder = JacksonHttps.createEncoder(objectMapper);
        JsonHttpCaller.JsonDecoder<R> decoder = JacksonHttps.createDecoder(objectMapper, returnClass);
        return JsonHttpCaller.forRequest((String)url, (JsonHttpCaller.JsonEncoder)encoder, decoder);
    }

    public static <R> JsonHttpCaller<R> forRequest(String url, JavaType javaType) {
        return JacksonHttps.forRequest(url, null, javaType);
    }

    public static <R> JsonHttpCaller<R> forRequest(String url, ObjectMapper objectMapper, JavaType javaType) {
        JsonHttpCaller.JsonEncoder encoder = JacksonHttps.createEncoder(objectMapper);
        JsonHttpCaller.JsonDecoder<R> decoder = JacksonHttps.createDecoder(objectMapper, javaType);
        return JsonHttpCaller.forRequest((String)url, (JsonHttpCaller.JsonEncoder)encoder, decoder);
    }

    public static <R> JsonHttpCaller<R> forRequest(String url, TypeReference<R> typeRef) {
        return JacksonHttps.forRequest(url, null, typeRef);
    }

    public static <R> JsonHttpCaller<R> forRequest(String url, ObjectMapper objectMapper, TypeReference<R> typeRef) {
        JsonHttpCaller.JsonEncoder encoder = JacksonHttps.createEncoder(objectMapper);
        JsonHttpCaller.JsonDecoder<R> decoder = JacksonHttps.createDecoder(objectMapper, typeRef);
        return JsonHttpCaller.forRequest((String)url, (JsonHttpCaller.JsonEncoder)encoder, decoder);
    }

    public static <R> JsonHttpCaller<R> forRequest(String url, JsonHttpCaller.JsonDecoder<R> decoder) {
        JsonHttpCaller.JsonEncoder encoder = JacksonHttps.createEncoder();
        return JsonHttpCaller.forRequest((String)url, (JsonHttpCaller.JsonEncoder)encoder, decoder);
    }

    public static <R> JsonHttpCaller<R> forRequest(String url, JsonHttpCaller.JsonEncoder encoder, JsonHttpCaller.JsonDecoder<R> decoder) {
        return JsonHttpCaller.forRequest((String)url, (JsonHttpCaller.JsonEncoder)encoder, decoder);
    }

    public static <D> JavaType constructParametricType(ObjectMapper objectMapper, Class<?> parametrized, Class<D> dataClass) {
        return objectMapper.getTypeFactory().constructParametricType(parametrized, new Class[]{dataClass});
    }

    public static <DE> JavaType constructListParametricType(ObjectMapper objectMapper, Class<?> parametrized, Class<DE> elementClass) {
        TypeFactory factory = objectMapper.getTypeFactory();
        CollectionLikeType likeType = factory.constructCollectionLikeType(List.class, elementClass);
        return factory.constructParametricType(parametrized, new JavaType[]{likeType});
    }

    private static ObjectMapper createObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        return objectMapper;
    }

    private static class JacksonTypeReferenceDecoder<R>
    implements JsonHttpCaller.JsonDecoder<R> {
        private final ObjectMapper objectMapper;
        private final TypeReference<R> typeRef;

        JacksonTypeReferenceDecoder(ObjectMapper objectMapper, TypeReference<R> typeRef) {
            Checks.verifyNotNull(typeRef, (String)"typeRef");
            this.objectMapper = objectMapper != null ? objectMapper : DEFAULT_OBJECT_MAPPER;
            this.typeRef = typeRef;
        }

        public R fromJson(String json) throws Exception {
            return (R)this.objectMapper.readValue(json, this.typeRef);
        }
    }

    private static class JacksonDecoder<R>
    implements JsonHttpCaller.JsonDecoder<R> {
        private final ObjectMapper objectMapper;
        private final JavaType javaType;

        JacksonDecoder(ObjectMapper objectMapper, Class<R> returnClass) {
            this(objectMapper, JacksonDecoder.javaType(objectMapper, returnClass));
        }

        JacksonDecoder(ObjectMapper objectMapper, JavaType javaType) {
            Checks.verifyNotNull((Object)javaType, (String)"javaType");
            this.objectMapper = JacksonDecoder.defaultIfNull(objectMapper);
            this.javaType = javaType;
        }

        public R fromJson(String json) throws Exception {
            return (R)this.objectMapper.readValue(json, this.javaType);
        }

        private static ObjectMapper defaultIfNull(ObjectMapper objectMapper) {
            return objectMapper != null ? objectMapper : DEFAULT_OBJECT_MAPPER;
        }

        private static JavaType javaType(ObjectMapper objectMapper, Class<?> returnClass) {
            objectMapper = JacksonDecoder.defaultIfNull(objectMapper);
            return objectMapper.getTypeFactory().constructType(returnClass);
        }
    }

    private static class JacksonEncoder
    implements JsonHttpCaller.JsonEncoder {
        private final ObjectMapper objectMapper;

        JacksonEncoder(ObjectMapper objectMapper) {
            this.objectMapper = objectMapper != null ? objectMapper : DEFAULT_OBJECT_MAPPER;
        }

        public String toJson(Object object) throws Exception {
            return this.objectMapper.writeValueAsString(object);
        }
    }
}

