/*
 * Decompiled with CFR 0.152.
 */
package net.apexes.commons.json.jackson;

import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.util.Collection;
import java.util.Date;
import net.apexes.commons.json.jackson.AdaptiveDateJsonDeserializer;
import net.apexes.commons.json.jackson.EnumeByIntegerJsonDeserializer;
import net.apexes.commons.json.jackson.EnumeByIntegerJsonSerializer;
import net.apexes.commons.json.jackson.EnumeByStringJsonDeserializer;
import net.apexes.commons.json.jackson.EnumeByStringJsonSerializer;
import net.apexes.commons.lang.Enume;
import net.apexes.commons.lang.EnumeRegistry;

public final class Jacksons {
    private Jacksons() {
    }

    public static SimpleModule createModule(EnumeRegistry enumeRegistry) {
        return Jacksons.createModule(enumeRegistry.getEnumeClasses());
    }

    public static SimpleModule createModule(Collection<Class<? extends Enume<?>>> enumeClasses) {
        return Jacksons.registerModule(new SimpleModule(), enumeClasses);
    }

    public static SimpleModule registerModule(SimpleModule module, EnumeRegistry enumeRegistry) {
        return Jacksons.registerModule(module, enumeRegistry.getEnumeClasses());
    }

    public static SimpleModule registerModule(SimpleModule module, Collection<Class<? extends Enume<?>>> enumeClasses) {
        for (Class<Enume<?>> clazz : enumeClasses) {
            Jacksons.registerModule(module, clazz);
        }
        return module;
    }

    public static SimpleModule registerModule(SimpleModule module, Class<? extends Enume<?>> enumeClass) {
        Class valueClass = Enume.valueClass(enumeClass);
        if (valueClass == String.class) {
            Class<? extends Enume<?>> classType = enumeClass;
            module.addSerializer(new EnumeByStringJsonSerializer(classType));
            module.addDeserializer(classType, new EnumeByStringJsonDeserializer(classType));
        } else if (valueClass == Integer.class) {
            Class<? extends Enume<?>> classType = enumeClass;
            module.addSerializer(new EnumeByIntegerJsonSerializer(classType));
            module.addDeserializer(classType, new EnumeByIntegerJsonDeserializer(classType));
        }
        return module;
    }

    public static SimpleModule adaptiveDateDeserializer(SimpleModule module) {
        return module.addDeserializer(Date.class, (JsonDeserializer)new AdaptiveDateJsonDeserializer());
    }
}

