/*
 * Copyright (c) 2018, apexes.net. All rights reserved.
 *
 *         http://www.apexes.net
 *
 */
package net.apexes.commons.json.gson;

import com.google.gson.Gson;
import net.apexes.commons.lang.Checks;
import net.apexes.commons.net.JsonHttpCaller;

import java.lang.reflect.Type;

/**
 * @author <a href="mailto:hedyn@foxmail.com">HeDYn</a>
 */
public final class GsonHttps {

    private GsonHttps() {}

    public static JsonHttpCaller.JsonEncoder createEncoder() {
        return createEncoder(null);
    }

    public static JsonHttpCaller.JsonEncoder createEncoder(Gson gson) {
        return new GsonEncoder(gson);
    }

    public static <R> JsonHttpCaller.JsonDecoder<R> createDecoder(Type returnType) {
        return createDecoder(null, returnType);
    }

    public static <R> JsonHttpCaller.JsonDecoder<R> createDecoder(Gson gson, Type returnType) {
        return new GsonDecoder<>(gson, returnType);
    }

    public static JsonHttpCaller.JsonHttpNoticer forNotice(String url) {
        return forNotice(url, createEncoder());
    }

    public static JsonHttpCaller.JsonHttpNoticer forNotice(String url, JsonHttpCaller.JsonEncoder encoder) {
        return JsonHttpCaller.forNotice(url, encoder);
    }

    public static <R> JsonHttpCaller<R> forRequest(String url, Type returnType) {
        return forRequest(url, null, returnType);
    }

    public static <R> JsonHttpCaller<R> forRequest(String url, Gson gson, Type returnType) {
        JsonHttpCaller.JsonEncoder encoder = createEncoder(gson);
        JsonHttpCaller.JsonDecoder<R> decoder = createDecoder(gson, returnType);
        return JsonHttpCaller.forRequest(url, encoder, decoder);
    }

    public static <R> JsonHttpCaller<R> forRequest(String url, JsonHttpCaller.JsonDecoder<R> decoder) {
        JsonHttpCaller.JsonEncoder encoder = createEncoder();
        return JsonHttpCaller.forRequest(url, encoder, decoder);
    }

    /**
     *
     * @author <a href="mailto:hedyn@foxmail.com">HeDYn</a>
     */
    private static class GsonEncoder implements JsonHttpCaller.JsonEncoder {

        private final Gson gson;

        GsonEncoder(Gson gson) {
            this.gson = gson != null ? gson : new Gson();
        }

        @Override
        public String toJson(Object object) throws Exception {
            return gson.toJson(object);
        }

    }

    /**
     *
     * @author <a href="mailto:hedyn@foxmail.com">HeDYn</a>
     *
     * @param <R>
     */
    private static class GsonDecoder<R> implements JsonHttpCaller.JsonDecoder<R> {

        private final Gson gson;
        private final Type returnType;

        GsonDecoder(Gson gson, Type returnType) {
            Checks.verifyNotNull(returnType, "returnType");
            this.gson = gson != null ? gson : new Gson();
            this.returnType = returnType;
        }

        @Override
        public R fromJson(String json) throws Exception {
            return gson.fromJson(json, returnType);
        }
    }

}
