/*
 * Copyright (c) 2018, apexes.net. All rights reserved.
 *
 *         http://www.apexes.net
 *
 */
package net.apexes.commons.json.gson;

import com.google.gson.GsonBuilder;
import net.apexes.commons.lang.Enume;
import net.apexes.commons.lang.EnumeRegistry;

import java.util.Collection;

/**
 * @author <a href="mailto:hedyn@foxmail.com">HeDYn</a>
 */
public final class Gsons {
    private Gsons() {}
    
    public static GsonBuilder createModule(EnumeRegistry enumeRegistry) {
        return createGsonBuilder(enumeRegistry.getEnumeClasses());
    }
    
    public static GsonBuilder createGsonBuilder(Collection<Class<? extends Enume<?>>> enumeClasses) {
        return registerGsonBuilder(new GsonBuilder(), enumeClasses);
    }
    
    public static GsonBuilder registerGsonBuilder(GsonBuilder gsonBuilder, EnumeRegistry enumeRegistry) {
        return registerGsonBuilder(gsonBuilder, enumeRegistry.getEnumeClasses());
    }
    
    public static GsonBuilder registerGsonBuilder(GsonBuilder gsonBuilder, Collection<Class<? extends Enume<?>>> enumeClasses) {
        for (Class<? extends Enume<?>> enumeClass : enumeClasses) {
            registerModule(gsonBuilder, enumeClass);
        }
        return gsonBuilder;
    }
    
    public static GsonBuilder registerModule(GsonBuilder gsonBuilder, Class<? extends Enume<?>> enumeClass) {
        Class<?> valueClass = Enume.valueClass(enumeClass);
        if (valueClass == String.class) {
            Class<Enume<String>> classType = (Class<Enume<String>>) enumeClass;
            gsonBuilder.registerTypeAdapter(classType, new EnumeByStringAdapter<>(classType));
        } else if (valueClass == Integer.class) {
            Class<Enume<Integer>> classType = (Class<Enume<Integer>>) enumeClass;
            gsonBuilder.registerTypeAdapter(classType, new EnumeByIntegerAdapter<>(classType));
        }
        return gsonBuilder;
    }
}
