/*
 * Copyright (c) 2018, apexes.net. All rights reserved.
 *
 *         http://www.apexes.net
 *
 */
package net.apexes.commons.json.jackson;

import com.fasterxml.jackson.databind.module.SimpleModule;
import net.apexes.commons.lang.Enume;
import net.apexes.commons.lang.EnumeRegistry;

import java.util.Collection;
import java.util.Date;

/**
 * @author <a href="mailto:hedyn@foxmail.com">HeDYn</a>
 */
public final class Jacksons {
    private Jacksons() {}
    
    public static SimpleModule createModule(EnumeRegistry enumeRegistry) {
        return createModule(enumeRegistry.getEnumeClasses());
    }
    
    public static SimpleModule createModule(Collection<Class<? extends Enume<?>>> enumeClasses) {
        return registerModule(new SimpleModule(), enumeClasses);
    }
    
    public static SimpleModule registerModule(SimpleModule module, EnumeRegistry enumeRegistry) {
        return registerModule(module, enumeRegistry.getEnumeClasses());
    }
    
    public static SimpleModule registerModule(SimpleModule module, Collection<Class<? extends Enume<?>>> enumeClasses) {
        for (Class<? extends Enume<?>> enumeClass : enumeClasses) {
            registerModule(module, enumeClass);
        }
        return module;
    }
    
    public static SimpleModule registerModule(SimpleModule module, Class<? extends Enume<?>> enumeClass) {
        Class<?> valueClass = Enume.valueClass(enumeClass);
        if (valueClass == String.class) {
            Class<Enume<String>> classType = (Class<Enume<String>>) enumeClass;
            module.addSerializer(new EnumeByStringJsonSerializer<>(classType));
            module.addDeserializer(classType, new EnumeByStringJsonDeserializer<>(classType));
        } else if (valueClass == Integer.class) {
            Class<Enume<Integer>> classType = (Class<Enume<Integer>>) enumeClass;
            module.addSerializer(new EnumeByIntegerJsonSerializer<>(classType));
            module.addDeserializer(classType, new EnumeByIntegerJsonDeserializer<>(classType));
        }
        return module;
    }

    public static SimpleModule adaptiveDateDeserializer(SimpleModule module) {
        return module.addDeserializer(Date.class, new AdaptiveDateJsonDeserializer());
    }
}
