/*
 * Decompiled with CFR 0.152.
 */
package net.apexes.commons.json.gson;

import com.google.gson.Gson;
import java.lang.reflect.Type;
import net.apexes.commons.json.gson.Gsons;
import net.apexes.commons.lang.Checks;
import net.apexes.commons.net.JsonHttpClient;

public final class GsonHttps {
    private GsonHttps() {
    }

    public static JsonHttpClient.JsonEncoder createEncoder() {
        return GsonHttps.createEncoder(null);
    }

    public static JsonHttpClient.JsonEncoder createEncoder(Gson gson) {
        return new GsonEncoder(gson);
    }

    public static <R> JsonHttpClient.JsonDecoder<R> createDecoder(Type returnType) {
        return GsonHttps.createDecoder(null, returnType);
    }

    public static <R> JsonHttpClient.JsonDecoder<R> createDecoder(Gson gson, Type returnType) {
        return new GsonDecoder(gson, returnType);
    }

    public static JsonHttpClient.JsonHttpNoticer forNotice(String url) {
        return GsonHttps.forNotice(url, GsonHttps.createEncoder());
    }

    public static JsonHttpClient.JsonHttpNoticer forNotice(String url, JsonHttpClient.JsonEncoder encoder) {
        return JsonHttpClient.forNotice((String)url, (JsonHttpClient.JsonEncoder)encoder);
    }

    public static <R> JsonHttpClient<R> forRequest(String url, Type returnType) {
        return GsonHttps.forRequest(url, null, returnType);
    }

    public static <R> JsonHttpClient<R> forRequest(String url, Gson gson, Type returnType) {
        JsonHttpClient.JsonEncoder encoder = GsonHttps.createEncoder(gson);
        JsonHttpClient.JsonDecoder<R> decoder = GsonHttps.createDecoder(gson, returnType);
        return JsonHttpClient.forRequest((String)url, (JsonHttpClient.JsonEncoder)encoder, decoder);
    }

    public static <R> JsonHttpClient<R> forRequest(String url, JsonHttpClient.JsonDecoder<R> decoder) {
        JsonHttpClient.JsonEncoder encoder = GsonHttps.createEncoder();
        return JsonHttpClient.forRequest((String)url, (JsonHttpClient.JsonEncoder)encoder, decoder);
    }

    private static class GsonEncoder
    implements JsonHttpClient.JsonEncoder {
        private final Gson gson;

        GsonEncoder(Gson gson) {
            this.gson = gson != null ? gson : new Gson();
        }

        public String toJson(Object object) throws Exception {
            if (object == null) {
                return null;
            }
            return this.gson.toJson(object);
        }
    }

    private static class GsonDecoder<R>
    implements JsonHttpClient.JsonDecoder<R> {
        private final Gson gson;
        private final Type returnType;

        GsonDecoder(Gson gson, Type returnType) {
            Checks.verifyNotNull((Object)returnType, (String)"returnType");
            this.gson = gson != null ? gson : Gsons.createGson();
            this.returnType = returnType;
        }

        public R fromJson(String json) throws Exception {
            return (R)this.gson.fromJson(json, this.returnType);
        }
    }
}

