/*
 * Decompiled with CFR 0.152.
 */
package net.apexes.commons.json.jackson;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import net.apexes.commons.json.jackson.Jacksons;
import net.apexes.commons.lang.Checks;
import net.apexes.commons.net.JsonHttpClient;

public final class JacksonHttps {
    private JacksonHttps() {
    }

    public static JsonHttpClient.JsonEncoder createEncoder() {
        return JacksonHttps.createEncoder(null);
    }

    public static JsonHttpClient.JsonEncoder createEncoder(ObjectMapper objectMapper) {
        return new JacksonEncoder(objectMapper);
    }

    public static <R> JsonHttpClient.JsonDecoder<R> createDecoder(Class<R> returnClass) {
        return JacksonHttps.createDecoder(null, returnClass);
    }

    public static <R> JsonHttpClient.JsonDecoder<R> createDecoder(ObjectMapper objectMapper, Class<R> returnClass) {
        return new JacksonDecoder<R>(objectMapper, returnClass);
    }

    public static <R> JsonHttpClient.JsonDecoder<R> createDecoder(JavaType javaType) {
        return JacksonHttps.createDecoder(null, javaType);
    }

    public static <R> JsonHttpClient.JsonDecoder<R> createDecoder(ObjectMapper objectMapper, JavaType javaType) {
        return new JacksonDecoder(objectMapper, javaType);
    }

    public static <R> JsonHttpClient.JsonDecoder<R> createDecoder(ObjectMapper objectMapper, TypeReference<R> typeRef) {
        return new JacksonTypeReferenceDecoder<R>(objectMapper, typeRef);
    }

    public static JsonHttpClient.JsonHttpNoticer forNotice(String url) {
        return JacksonHttps.forNotice(url, JacksonHttps.createEncoder());
    }

    public static JsonHttpClient.JsonHttpNoticer forNotice(String url, JsonHttpClient.JsonEncoder encoder) {
        return JsonHttpClient.forNotice((String)url, (JsonHttpClient.JsonEncoder)encoder);
    }

    public static <R> JsonHttpClient<R> forRequest(String url, Class<R> returnClass) {
        return JacksonHttps.forRequest(url, null, returnClass);
    }

    public static <R> JsonHttpClient<R> forRequest(String url, ObjectMapper objectMapper, Class<R> returnClass) {
        JsonHttpClient.JsonEncoder encoder = JacksonHttps.createEncoder(objectMapper);
        JsonHttpClient.JsonDecoder<R> decoder = JacksonHttps.createDecoder(objectMapper, returnClass);
        return JsonHttpClient.forRequest((String)url, (JsonHttpClient.JsonEncoder)encoder, decoder);
    }

    public static <R> JsonHttpClient<R> forRequest(String url, JavaType javaType) {
        return JacksonHttps.forRequest(url, null, javaType);
    }

    public static <R> JsonHttpClient<R> forRequest(String url, ObjectMapper objectMapper, JavaType javaType) {
        JsonHttpClient.JsonEncoder encoder = JacksonHttps.createEncoder(objectMapper);
        JsonHttpClient.JsonDecoder<R> decoder = JacksonHttps.createDecoder(objectMapper, javaType);
        return JsonHttpClient.forRequest((String)url, (JsonHttpClient.JsonEncoder)encoder, decoder);
    }

    public static <R> JsonHttpClient<R> forRequest(String url, TypeReference<R> typeRef) {
        return JacksonHttps.forRequest(url, null, typeRef);
    }

    public static <R> JsonHttpClient<R> forRequest(String url, ObjectMapper objectMapper, TypeReference<R> typeRef) {
        JsonHttpClient.JsonEncoder encoder = JacksonHttps.createEncoder(objectMapper);
        JsonHttpClient.JsonDecoder<R> decoder = JacksonHttps.createDecoder(objectMapper, typeRef);
        return JsonHttpClient.forRequest((String)url, (JsonHttpClient.JsonEncoder)encoder, decoder);
    }

    public static <R> JsonHttpClient<R> forRequest(String url, JsonHttpClient.JsonDecoder<R> decoder) {
        JsonHttpClient.JsonEncoder encoder = JacksonHttps.createEncoder();
        return JsonHttpClient.forRequest((String)url, (JsonHttpClient.JsonEncoder)encoder, decoder);
    }

    public static <R> JsonHttpClient<R> forRequest(String url, JsonHttpClient.JsonEncoder encoder, JsonHttpClient.JsonDecoder<R> decoder) {
        return JsonHttpClient.forRequest((String)url, (JsonHttpClient.JsonEncoder)encoder, decoder);
    }

    private static class JacksonEncoder
    implements JsonHttpClient.JsonEncoder {
        private final ObjectMapper objectMapper;

        JacksonEncoder(ObjectMapper objectMapper) {
            this.objectMapper = objectMapper != null ? objectMapper : Jacksons.defaultObjectMapper;
        }

        public String toJson(Object object) throws Exception {
            if (object == null) {
                return null;
            }
            return this.objectMapper.writeValueAsString(object);
        }
    }

    private static class JacksonDecoder<R>
    implements JsonHttpClient.JsonDecoder<R> {
        private final ObjectMapper objectMapper;
        private final JavaType javaType;

        JacksonDecoder(ObjectMapper objectMapper, Class<R> returnClass) {
            this(objectMapper, JacksonDecoder.javaType(objectMapper, returnClass));
        }

        JacksonDecoder(ObjectMapper objectMapper, JavaType javaType) {
            Checks.verifyNotNull((Object)javaType, (String)"javaType");
            this.objectMapper = JacksonDecoder.defaultIfNull(objectMapper);
            this.javaType = javaType;
        }

        public R fromJson(String json) throws Exception {
            return (R)this.objectMapper.readValue(json, this.javaType);
        }

        private static ObjectMapper defaultIfNull(ObjectMapper objectMapper) {
            return objectMapper != null ? objectMapper : Jacksons.defaultObjectMapper;
        }

        private static JavaType javaType(ObjectMapper objectMapper, Class<?> returnClass) {
            objectMapper = JacksonDecoder.defaultIfNull(objectMapper);
            return objectMapper.getTypeFactory().constructType(returnClass);
        }
    }

    private static class JacksonTypeReferenceDecoder<R>
    implements JsonHttpClient.JsonDecoder<R> {
        private final ObjectMapper objectMapper;
        private final TypeReference<R> typeRef;

        JacksonTypeReferenceDecoder(ObjectMapper objectMapper, TypeReference<R> typeRef) {
            Checks.verifyNotNull(typeRef, (String)"typeRef");
            this.objectMapper = objectMapper != null ? objectMapper : Jacksons.defaultObjectMapper;
            this.typeRef = typeRef;
        }

        public R fromJson(String json) throws Exception {
            return (R)this.objectMapper.readValue(json, this.typeRef);
        }
    }
}

