/*
 * Decompiled with CFR 0.152.
 */
package net.apexes.commons.json.jackson;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.type.CollectionLikeType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import net.apexes.commons.json.jackson.AdaptiveDateJsonDeserializer;
import net.apexes.commons.json.jackson.EnumeByIntegerJsonDeserializer;
import net.apexes.commons.json.jackson.EnumeByIntegerJsonSerializer;
import net.apexes.commons.json.jackson.EnumeByStringJsonDeserializer;
import net.apexes.commons.json.jackson.EnumeByStringJsonSerializer;
import net.apexes.commons.lang.Enume;
import net.apexes.commons.lang.EnumeRegistry;

public final class Jacksons {
    public static final ObjectMapper defaultObjectMapper = Jacksons.createObjectMapper();

    private Jacksons() {
    }

    private static ObjectMapper createObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        return objectMapper;
    }

    public static ObjectMapper forDefault(EnumeRegistry enumeRegistry) {
        return Jacksons.forDefault(enumeRegistry.getEnumeClasses());
    }

    public static ObjectMapper forDefault(Collection<Class<? extends Enume<?>>> enumeClasses) {
        defaultObjectMapper.registerModule((Module)Jacksons.createModule(enumeClasses));
        return defaultObjectMapper;
    }

    public static SimpleModule createModule(EnumeRegistry enumeRegistry) {
        return Jacksons.createModule(enumeRegistry.getEnumeClasses());
    }

    public static SimpleModule createModule(Collection<Class<? extends Enume<?>>> enumeClasses) {
        return Jacksons.register(new SimpleModule(), enumeClasses);
    }

    public static SimpleModule register(SimpleModule module, EnumeRegistry enumeRegistry) {
        return Jacksons.register(module, enumeRegistry.getEnumeClasses());
    }

    public static SimpleModule register(SimpleModule module, Collection<Class<? extends Enume<?>>> enumeClasses) {
        for (Class<Enume<?>> clazz : enumeClasses) {
            Jacksons.register(module, clazz);
        }
        return module;
    }

    public static SimpleModule register(SimpleModule module, Class<? extends Enume<?>> enumeClass) {
        Class valueClass = Enume.valueClass(enumeClass);
        if (valueClass == String.class) {
            Class<? extends Enume<?>> classType = enumeClass;
            module.addSerializer(new EnumeByStringJsonSerializer(classType));
            return module.addDeserializer(classType, new EnumeByStringJsonDeserializer(classType));
        }
        if (valueClass == Integer.class) {
            Class<? extends Enume<?>> classType = enumeClass;
            module.addSerializer(new EnumeByIntegerJsonSerializer(classType));
            return module.addDeserializer(classType, new EnumeByIntegerJsonDeserializer(classType));
        }
        throw new IllegalArgumentException("value only be String or Integer.");
    }

    public static SimpleModule adaptiveDateDeserializer(SimpleModule module) {
        return module.addDeserializer(Date.class, (JsonDeserializer)AdaptiveDateJsonDeserializer.INSTANCE);
    }

    public static <D> JavaType constructParametricType(ObjectMapper objectMapper, Class<?> parametrized, Class<D> dataClass) {
        return objectMapper.getTypeFactory().constructParametricType(parametrized, new Class[]{dataClass});
    }

    public static <DE> JavaType constructListParametricType(ObjectMapper objectMapper, Class<?> parametrized, Class<DE> elementClass) {
        TypeFactory factory = objectMapper.getTypeFactory();
        CollectionLikeType likeType = factory.constructCollectionLikeType(List.class, elementClass);
        return factory.constructParametricType(parametrized, new JavaType[]{likeType});
    }
}

