/*
 * Decompiled with CFR 0.152.
 */
package net.apexes.commons.json.gson;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.Collection;
import net.apexes.commons.json.gson.EnumeByIntegerAdapter;
import net.apexes.commons.json.gson.EnumeByStringAdapter;
import net.apexes.commons.lang.Enume;
import net.apexes.commons.lang.EnumeRegistry;

public final class Gsons {
    public static final GsonBuilder defaultGsonBuilder = new GsonBuilder();

    private Gsons() {
    }

    public static Gson createGson() {
        return defaultGsonBuilder.create();
    }

    public static GsonBuilder forDefault(EnumeRegistry enumeRegistry) {
        return Gsons.forDefault(enumeRegistry.getEnumeClasses());
    }

    public static GsonBuilder forDefault(Collection<Class<? extends Enume<?>>> enumeClasses) {
        return Gsons.register(defaultGsonBuilder, enumeClasses);
    }

    public static GsonBuilder createGsonBuilder(EnumeRegistry enumeRegistry) {
        return Gsons.createGsonBuilder(enumeRegistry.getEnumeClasses());
    }

    public static GsonBuilder createGsonBuilder(Collection<Class<? extends Enume<?>>> enumeClasses) {
        return Gsons.register(new GsonBuilder(), enumeClasses);
    }

    public static GsonBuilder register(GsonBuilder gsonBuilder, EnumeRegistry enumeRegistry) {
        return Gsons.register(gsonBuilder, enumeRegistry.getEnumeClasses());
    }

    public static GsonBuilder register(GsonBuilder gsonBuilder, Collection<Class<? extends Enume<?>>> enumeClasses) {
        for (Class<Enume<?>> clazz : enumeClasses) {
            Gsons.register(gsonBuilder, clazz);
        }
        return gsonBuilder;
    }

    public static GsonBuilder register(GsonBuilder gsonBuilder, Class<? extends Enume<?>> enumeClass) {
        Class valueClass = Enume.valueClass(enumeClass);
        if (valueClass == String.class) {
            Class<? extends Enume<?>> classType = enumeClass;
            return gsonBuilder.registerTypeAdapter(classType, new EnumeByStringAdapter(classType));
        }
        if (valueClass == Integer.class) {
            Class<? extends Enume<?>> classType = enumeClass;
            return gsonBuilder.registerTypeAdapter(classType, new EnumeByIntegerAdapter(classType));
        }
        throw new IllegalArgumentException("value only be String or Integer.");
    }
}

