/*
 * Decompiled with CFR 0.152.
 */
package net.apexes.commons.json.jackson;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import java.io.IOException;
import java.text.ParseException;
import java.util.Date;
import net.apexes.commons.lang.Dates;

public class AdaptiveDateJsonDeserializer
extends JsonDeserializer<Date> {
    public static final AdaptiveDateJsonDeserializer INSTANCE = new AdaptiveDateJsonDeserializer();

    protected AdaptiveDateJsonDeserializer() {
    }

    public Date deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        String dateStr;
        String temp = dateStr = jp.getText();
        try {
            return Dates.parseAdaptive((String)dateStr);
        }
        catch (ParseException e) {
            throw new JsonDateParseException(temp, e);
        }
    }

    public static class JsonDateParseException
    extends JsonProcessingException {
        private static final long serialVersionUID = 1L;

        protected JsonDateParseException(String msg, Throwable rootCause) {
            super(msg, rootCause);
        }
    }
}

