/*
 * Copyright (c) 2018, apexes.net. All rights reserved.
 *
 *         http://www.apexes.net
 *
 */
package net.apexes.commons.lang;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

/**
 * @author <a href=mailto:hedyn@foxmail.com>HeDYn</a>
 */
public final class Streams {
    private Streams() {}

    /**
     * 将文件输出到输出流中
     * @param sourceFile
     * @param targetOs
     * @param snapshoot 如果文件正在做追加操作，为 true 时只输出操作时的快照内容
     * @throws Exception
     */
    public static void transfer(File sourceFile, OutputStream targetOs, boolean snapshoot) throws Exception {
        byte[] buf = new byte[10240];
        long fileLen = sourceFile.length();
        long outLen = 0;
        try (FileInputStream fis = new FileInputStream(sourceFile)) {
            int len;
            while ((len = fis.read(buf)) != -1) {
                targetOs.write(buf, 0, len);
                if (snapshoot) {
                    outLen += len;
                    if (outLen >= fileLen) {
                        break;
                    }
                }
            }
        }
    }

    public static byte[] toByteArray(InputStream is) throws IOException {
        ByteArrayOutputStream swapStream = new ByteArrayOutputStream();
        byte[] buff = new byte[10240];
        int len;
        while ((len = is.read(buff)) > 0) {
            swapStream.write(buff, 0, len);
        }
        return swapStream.toByteArray();
    }

    public static String toString(InputStream is, String charsetName) throws IOException {
        return new String(toByteArray(is), charsetName);
    }

}
