/*
 * Decompiled with CFR 0.152.
 */
package net.apexes.commons.i18n;

import java.text.MessageFormat;
import java.util.Locale;
import net.apexes.commons.i18n.I18nResource;

public class I18nMsg {
    protected final Logger logger;
    protected final I18nResource resource;

    public I18nMsg(I18nResource resource) {
        this(resource, new IgnoreLogger());
    }

    public I18nMsg(I18nResource resource, Logger logger) {
        this.resource = resource;
        this.logger = logger;
    }

    public Locale getLocale() {
        return this.resource.getLocale();
    }

    public String getMessage(String key) {
        return this.getMessage(key, key);
    }

    public String getMessage(String key, String defaultValue) {
        String value = null;
        try {
            value = this.resource.getString(key);
        }
        catch (Exception e) {
            this.logger.logNotFoundKey(key);
        }
        if (value == null) {
            value = defaultValue;
        }
        return value;
    }

    public String formatKey(String key, Object ... params) {
        return this.format(this.getMessage(key), params);
    }

    private String format(String format, Object ... params) {
        if (params != null && params.length > 0) {
            try {
                String pattern = format.replaceAll("'", "''");
                return MessageFormat.format(pattern, params);
            }
            catch (Exception e) {
                this.logger.logFormatError(e, format, params);
            }
        }
        return format;
    }

    private static class IgnoreLogger
    implements Logger {
        private IgnoreLogger() {
        }

        @Override
        public void logNotFoundKey(String key) {
        }

        @Override
        public void logFormatError(Exception e, String format, Object ... params) {
        }
    }

    public static interface Logger {
        public void logNotFoundKey(String var1);

        public void logFormatError(Exception var1, String var2, Object ... var3);
    }
}

