/*
 * Decompiled with CFR 0.152.
 */
package net.apexes.commons.lang;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;

public final class Dates {
    public static final String DATE_PATTERN = "yyyy-MM-dd";
    public static final String DATETIME_PATTERN = "yyyy-MM-dd HH:mm:ss";
    public static final String TIMESTAMP_PATTERN = "yyyy-MM-dd HH:mm:ss.SSS";
    public static final String ISO8601_DATE_WITHOUT_ZONE_PATTERN = "yyyy-MM-dd'T'HH:mm:ss";
    public static final String ISO8601_TIMESTAMP_WITHOUT_ZONE_PATTERN = "yyyy-MM-dd'T'HH:mm:ss.SSS";
    public static final String TIME_PATTERN = "HH:mm:ss";
    public static final String YYMMDD_PATTERN = "yyMMdd";
    public static final String YYYYMMDD_PATTERN = "yyyyMMdd";
    public static final String YYYYMMDDHHMMSS_PATTERN = "yyyyMMddHHmmss";
    public static final String MMDD_PATTERN = "MMdd";

    private Dates() {
    }

    public static long networkTimeMillis() throws IOException {
        return Dates.networkTimeMillis("http://www.baidu.com", "http://www.google.com", "http://www.taobao.com");
    }

    public static long networkTimeMillis(String ... urls) throws IOException {
        return Dates.networkTimeMillis(3, urls);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long networkTimeMillis(int connectTimeout, String ... urls) throws IOException {
        IOException exception = null;
        for (String webUrl : urls) {
            HttpURLConnection httpConn = null;
            try {
                long timeMs;
                URL url = new URL(webUrl);
                URLConnection uc = url.openConnection();
                if (connectTimeout > 0) {
                    uc.setConnectTimeout(connectTimeout);
                }
                uc.connect();
                if (uc instanceof HttpURLConnection) {
                    httpConn = (HttpURLConnection)uc;
                }
                if ((timeMs = uc.getDate()) <= 0L) continue;
                long l = timeMs;
                return l;
            }
            catch (IOException e) {
                exception = e;
            }
            finally {
                if (httpConn != null) {
                    httpConn.disconnect();
                }
            }
        }
        if (exception == null) {
            exception = new IOException("Connect failed.");
        }
        throw exception;
    }

    public static Date yearStart(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(date.getTime());
        int year = calendar.get(1);
        calendar.clear();
        calendar.set(1, year);
        return calendar.getTime();
    }

    public static Date dateStart(Date date) {
        if (date == null) {
            return date;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static int dayDiff(Date from, Date to) {
        SimpleDateFormat df = new SimpleDateFormat(DATE_PATTERN);
        try {
            from = df.parse(df.format(from));
            to = df.parse(df.format(to));
        }
        catch (Exception ex) {
            throw new RuntimeException();
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(to);
        long toTime = calendar.getTimeInMillis() + (long)calendar.get(16);
        calendar.setTime(from);
        long fromTime = calendar.getTimeInMillis() + (long)calendar.get(16);
        long days = Math.round((double)((toTime /= 1000L) - (fromTime /= 1000L)) / 86400.0);
        return (int)days;
    }

    public static int dayCompare(Date date1, Date date2) {
        SimpleDateFormat df = new SimpleDateFormat(YYYYMMDD_PATTERN, Locale.US);
        Integer i1 = Integer.valueOf(df.format(date1));
        Integer i2 = Integer.valueOf(df.format(date2));
        return i1.compareTo(i2);
    }

    public static boolean isSameDay(Date date1, Date date2) {
        if (date1 != null && date2 != null) {
            Calendar c1 = Calendar.getInstance();
            c1.setTime(date1);
            Calendar c2 = Calendar.getInstance();
            c2.setTime(date2);
            return c1.get(1) == c2.get(1) && c1.get(2) == c2.get(2) && c1.get(5) == c2.get(5);
        }
        return false;
    }

    public static boolean isDateOverlap(Date startDate1, Date endDate1, Date startDate2, Date endDate2, boolean ignoreYearS1, boolean ignoreYearE1, boolean ignoreYearS2, boolean ignoreYearE2) {
        int iEndDate2;
        int iEndDate1;
        int iStartDate2;
        int iStartDate1;
        SimpleDateFormat ymdFmt = new SimpleDateFormat(YYYYMMDD_PATTERN);
        SimpleDateFormat mdFmt = new SimpleDateFormat(MMDD_PATTERN);
        if (ignoreYearS1 != ignoreYearS2) {
            int year = ignoreYearS1 ? Dates.toYear(startDate2) : Dates.toYear(startDate1);
            iStartDate1 = Integer.parseInt(year + mdFmt.format(startDate1));
            iStartDate2 = Integer.parseInt(year + mdFmt.format(startDate2));
        } else if (ignoreYearS1) {
            iStartDate1 = Integer.parseInt("1" + mdFmt.format(startDate1));
            iStartDate2 = Integer.parseInt("1" + mdFmt.format(startDate2));
        } else {
            iStartDate1 = Integer.parseInt(ymdFmt.format(startDate1));
            iStartDate2 = Integer.parseInt(ymdFmt.format(startDate2));
        }
        if (ignoreYearE1 != ignoreYearE2) {
            int year = ignoreYearE1 ? Dates.toYear(endDate2) : Dates.toYear(endDate1);
            iEndDate1 = Integer.parseInt(year + mdFmt.format(endDate1));
            iEndDate2 = Integer.parseInt(year + mdFmt.format(endDate2));
        } else if (ignoreYearE1) {
            iEndDate1 = Integer.parseInt("1" + mdFmt.format(endDate1));
            iEndDate2 = Integer.parseInt("1" + mdFmt.format(endDate2));
        } else {
            iEndDate1 = Integer.parseInt(ymdFmt.format(endDate1));
            iEndDate2 = Integer.parseInt(ymdFmt.format(endDate2));
        }
        return iStartDate1 <= iStartDate2 && iStartDate2 <= iEndDate1 || iStartDate1 <= iEndDate2 && iEndDate2 <= iEndDate1 || iStartDate2 < iStartDate1 && iEndDate1 < iEndDate2;
    }

    private static int toYear(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar.get(1);
    }

    public static String format(Date date, String pattern) {
        return new SimpleDateFormat(pattern).format(date);
    }

    public static Date parse(String date, String pattern) throws ParseException {
        return new SimpleDateFormat(pattern).parse(date);
    }

    public static Date parseAdaptive(String dateStr) throws ParseException {
        if (dateStr == null || dateStr.isEmpty()) {
            return null;
        }
        String fm = null;
        if (dateStr.contains(":")) {
            if (dateStr.contains("T")) {
                fm = dateStr.contains(".") ? ISO8601_TIMESTAMP_WITHOUT_ZONE_PATTERN : ISO8601_DATE_WITHOUT_ZONE_PATTERN;
            } else if (dateStr.contains(":")) {
                fm = dateStr.contains(".") ? TIMESTAMP_PATTERN : DATETIME_PATTERN;
            }
        } else if (dateStr.indexOf(45) > 1) {
            fm = DATE_PATTERN;
        }
        if (fm != null) {
            return new SimpleDateFormat(fm).parse(dateStr);
        }
        return new Date(Long.parseLong(dateStr));
    }
}

