/*
 * Decompiled with CFR 0.152.
 */
package net.apexes.commons.lang;

import java.nio.ByteBuffer;
import java.util.UUID;
import net.apexes.commons.lang.Base58;
import net.apexes.commons.lang.Bytes;
import net.apexes.commons.lang.IDGenerator;
import net.apexes.commons.lang.ObjectId;
import net.apexes.commons.lang.Secrets;

public final class IDs {
    private IDs() {
    }

    public static IDGenerator idGenerator(int major, short minor) {
        byte[] namespaceBytes = new byte[6];
        byte[] majorBytes = Bytes.intToBytes(major);
        byte[] minorBytes = Bytes.shortToBytes(minor);
        System.arraycopy(majorBytes, 0, namespaceBytes, 0, 4);
        namespaceBytes[3] = minorBytes[0];
        namespaceBytes[4] = minorBytes[1];
        return IDGenerator.namespace(namespaceBytes);
    }

    public static IDGenerator idGenerator(long namespace) {
        if (namespace < 0L || namespace > 0xFFFFFFFFFFFFL) {
            throw new IllegalArgumentException("range between 0 and 0xFFFFFFFFFFFF");
        }
        return IDGenerator.namespace(namespace);
    }

    public static String newId() {
        return IDGenerator.genId();
    }

    public static String newObjectId() {
        return Base58.encode(ObjectId.get().toByteArray());
    }

    public static String md5Id(String text) {
        return IDs.toBase58Id(Secrets.md5(text));
    }

    public static String randomBase58UUID() {
        return IDs.toBase58UUID(UUID.randomUUID());
    }

    public static byte[] toByteArray(UUID uuid) {
        ByteBuffer buf = ByteBuffer.allocate(16);
        buf.putLong(uuid.getMostSignificantBits());
        buf.putLong(uuid.getLeastSignificantBits());
        return buf.array();
    }

    public static UUID toUUID(byte[] byteArray) {
        assert (byteArray.length == 16);
        ByteBuffer buf = ByteBuffer.wrap(byteArray);
        long msb = buf.getLong();
        long lsb = buf.getLong();
        return new UUID(msb, lsb);
    }

    public static String toBase58UUID(UUID uuid) {
        return IDs.toBase58Id(IDs.toByteArray(uuid));
    }

    public static UUID formBase58UUID(String base58UUID) {
        return IDs.toUUID(IDs.fromBase58Id(base58UUID));
    }

    static String toBase58Id(byte[] bytes) {
        assert (bytes.length == 16);
        String base58Id = Base58.encode(bytes);
        while (base58Id.length() < 22) {
            base58Id = "0" + base58Id;
        }
        return base58Id;
    }

    static byte[] fromBase58Id(String base58Id) {
        assert (base58Id.length() == 22);
        while (base58Id.charAt(0) == '0') {
            base58Id = base58Id.substring(1);
        }
        return Base58.decode(base58Id);
    }
}

