/*
 * Decompiled with CFR 0.152.
 */
package net.apexes.commons.lang;

public class Radix62 {
    public static final char[] ALPHABET;
    private static final int BASE = 62;
    private static final int MAX_ALPHABET = 122;
    private static final int[] DIGITS_INDEX;

    public static String encode(long num) {
        if (num == 0L) {
            return "0";
        }
        boolean negative = false;
        if (num < 0L) {
            negative = true;
            num = -num;
        }
        StringBuilder buf = new StringBuilder();
        while (num != 0L) {
            buf.append(ALPHABET[(int)(num % 62L)]);
            num /= 62L;
        }
        if (negative) {
            buf.append("-");
        }
        return buf.reverse().toString();
    }

    public static long decode(String str) {
        boolean negative = false;
        if (str.charAt(0) == '-') {
            str = str.substring(1, str.length());
            negative = true;
        }
        long num = 0L;
        long multiplier = 1L;
        for (int pos = str.length() - 1; pos >= 0; --pos) {
            num += (long)Radix62.getIndex(str, pos) * multiplier;
            multiplier *= 62L;
        }
        return negative ? -num : num;
    }

    private static int getIndex(String s, int pos) {
        char c = s.charAt(pos);
        if (c > 'z') {
            throw new IllegalArgumentException("Unknow character for Radix62: " + s);
        }
        int index = DIGITS_INDEX[c];
        if (index == -1) {
            throw new IllegalArgumentException("Unknow character for Radix62: " + s);
        }
        return index;
    }

    static {
        int i;
        ALPHABET = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz".toCharArray();
        DIGITS_INDEX = new int[123];
        for (i = 0; i < 122; ++i) {
            Radix62.DIGITS_INDEX[i] = -1;
        }
        for (i = 0; i < 62; ++i) {
            Radix62.DIGITS_INDEX[Radix62.ALPHABET[i]] = i;
        }
    }
}

