/*
 * Decompiled with CFR 0.152.
 */
package net.apexes.commons.lang;

import net.apexes.commons.lang.ValueEnums;

public interface ValueEnum<T> {
    public T value();

    public boolean eqValue(T var1);

    public boolean isUnknown();

    public void setUnknownValue(T var1);

    public static final class Helper<T> {
        private final T value;
        private final boolean unknown;
        private T unknownValue;

        public static <T> Helper<T> valueHelper(T value) {
            return new Helper<T>(value);
        }

        public static <T> Helper<T> unknownHelper() {
            return new Helper<T>();
        }

        private Helper(T value) {
            this.value = value;
            this.unknown = false;
        }

        private Helper() {
            this.value = null;
            this.unknown = true;
        }

        public T value() {
            return this.unknown ? this.unknownValue : this.value;
        }

        public <E extends Enum<E>> boolean equalsValue(E valueEnum, T value) {
            return ValueEnums.eqValue((ValueEnum)((Object)valueEnum), value);
        }

        public boolean isUnknown() {
            return this.unknown;
        }

        public void setUnknownValue(T value) {
            if (!this.unknown) {
                throw new UnsupportedOperationException("Must be unknown enum.");
            }
            this.unknownValue = value;
        }
    }
}

