/*
 * Decompiled with CFR 0.152.
 */
package net.apexes.commons.lang;

import java.io.LineNumberReader;
import java.io.Reader;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SQLScriptRunner {
    private static final Logger LOG = Logger.getLogger(SQLScriptRunner.class.getName());
    private static final String DEFAULT_DELIMITER = ";";
    private final Connection connection;
    private final boolean stopOnError;
    private final boolean autoCommit;
    private String delimiter = ";";
    private boolean fullLineDelimiter = false;

    public SQLScriptRunner(Connection connection, boolean autoCommit, boolean stopOnError) {
        this.connection = connection;
        this.autoCommit = autoCommit;
        this.stopOnError = stopOnError;
    }

    public void setDelimiter(String delimiter, boolean fullLineDelimiter) {
        this.delimiter = delimiter;
        this.fullLineDelimiter = fullLineDelimiter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runScript(Reader reader) throws SQLException {
        StringBuilder command = null;
        boolean exception = false;
        try {
            String line;
            LineNumberReader lineReader = new LineNumberReader(reader);
            while ((line = lineReader.readLine()) != null) {
                String trimmedLine;
                if (command == null) {
                    command = new StringBuilder();
                }
                if ((trimmedLine = line.trim()).startsWith("--") || trimmedLine.length() < 1 || trimmedLine.startsWith("//") || trimmedLine.length() < 1 || trimmedLine.startsWith("--")) continue;
                if (!this.fullLineDelimiter && trimmedLine.endsWith(this.getDelimiter()) || this.fullLineDelimiter && trimmedLine.equals(this.getDelimiter())) {
                    command.append(line.substring(0, line.lastIndexOf(this.getDelimiter())));
                    command.append(" ");
                    this.executeCommand(command.toString());
                    command = null;
                    Thread.yield();
                    continue;
                }
                command.append(line);
                command.append(" ");
            }
            if (!this.autoCommit) {
                this.connection.commit();
            }
        }
        catch (SQLException e) {
            LOG.log(Level.SEVERE, "Error executing: " + command, e);
            exception = true;
            throw e;
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, "Error executing: " + command, e);
            exception = true;
        }
        finally {
            if (exception) {
                this.connection.rollback();
            }
        }
    }

    private void executeCommand(String command) throws SQLException {
        block20: {
            try (Statement statement = this.connection.createStatement();){
                LOG.info(command);
                boolean hasResults = false;
                if (this.stopOnError) {
                    hasResults = statement.execute(command);
                } else {
                    try {
                        statement.execute(command);
                    }
                    catch (SQLException e) {
                        LOG.log(Level.SEVERE, "Error executing: " + command, e);
                    }
                }
                if (this.autoCommit && !this.connection.getAutoCommit()) {
                    this.connection.commit();
                }
                if (!hasResults) break block20;
                try (ResultSet rs = statement.getResultSet();){
                    int i;
                    StringBuilder sb = new StringBuilder();
                    ResultSetMetaData md = rs.getMetaData();
                    int cols = md.getColumnCount();
                    for (i = 0; i < cols; ++i) {
                        String name = md.getColumnLabel(i + 1);
                        sb.append(name).append("\t");
                    }
                    LOG.info(sb.toString());
                    while (rs.next()) {
                        sb.setLength(0);
                        for (i = 0; i < cols; ++i) {
                            String value = rs.getString(i + 1);
                            sb.append(value).append("\t");
                        }
                        LOG.info(sb.toString());
                    }
                }
            }
        }
    }

    private String getDelimiter() {
        return this.delimiter;
    }
}

