/*
 * Decompiled with CFR 0.152.
 */
package net.apexes.commons.lang;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import net.apexes.commons.lang.Checks;

public class Skip32 {
    private static final int[] F = new int[]{163, 215, 9, 131, 248, 72, 246, 244, 179, 33, 21, 120, 153, 177, 175, 249, 231, 45, 77, 138, 206, 76, 202, 46, 82, 149, 217, 30, 78, 56, 68, 40, 10, 223, 2, 160, 23, 241, 96, 104, 18, 183, 122, 195, 233, 250, 61, 83, 150, 132, 107, 186, 242, 99, 154, 25, 124, 174, 229, 245, 247, 22, 106, 162, 57, 182, 123, 15, 193, 147, 129, 27, 238, 180, 26, 234, 208, 145, 47, 184, 85, 185, 218, 133, 63, 65, 191, 224, 90, 88, 128, 95, 102, 11, 216, 144, 53, 213, 192, 167, 51, 6, 101, 105, 69, 0, 148, 86, 109, 152, 155, 118, 151, 252, 178, 194, 176, 254, 219, 32, 225, 235, 214, 228, 221, 71, 74, 29, 66, 237, 158, 110, 73, 60, 205, 67, 39, 210, 7, 212, 222, 199, 103, 24, 137, 203, 48, 31, 141, 198, 143, 170, 200, 116, 220, 201, 93, 92, 49, 164, 112, 136, 97, 44, 159, 13, 43, 135, 80, 130, 84, 100, 38, 125, 3, 64, 52, 75, 28, 115, 209, 196, 253, 59, 204, 251, 127, 171, 230, 62, 91, 165, 173, 4, 35, 156, 20, 81, 34, 240, 41, 121, 113, 126, 255, 140, 14, 226, 12, 239, 188, 114, 117, 111, 55, 161, 236, 211, 142, 98, 139, 134, 16, 232, 8, 119, 17, 190, 146, 79, 36, 197, 50, 54, 157, 207, 243, 166, 187, 172, 94, 108, 169, 19, 87, 37, 181, 227, 189, 168, 58, 1, 5, 89, 42, 70};

    public static long encrypt(int value, String key) {
        return Skip32.skip32(value, Skip32.verifyKey(key), true);
    }

    public static int decrypt(long value, String key) {
        return (int)Skip32.skip32(value, Skip32.verifyKey(key), false);
    }

    private static String verifyKey(String key) {
        Checks.verifyNotNull(key, "key");
        if (key.length() != 10) {
            throw new IllegalArgumentException("The key length must equal to 10.");
        }
        return key;
    }

    private static long skip32(long number, String key, boolean encrypt) {
        ByteBuffer buffer = ByteBuffer.allocate(8);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        buffer.putLong(number);
        byte[] b = buffer.array();
        int[] a = new int[b.length];
        for (int i = 0; i < b.length; ++i) {
            a[i] = b[i] & 0xFF;
        }
        int[] buf = new int[4];
        for (int i = 0; i < 4; ++i) {
            buf[i] = a[i];
        }
        int[] k = new int[10];
        for (int i = 0; i < k.length; ++i) {
            k[i] = key.codePointAt(i);
        }
        Skip32.skip32(k, buf, encrypt);
        int index = 0;
        int firstByte = 0xFF & buf[index];
        int secondByte = 0xFF & buf[index + 1];
        int thirdByte = 0xFF & buf[index + 2];
        int fourthByte = 0xFF & buf[index + 3];
        long anUnsignedInt = (long)(fourthByte << 24 | thirdByte << 16 | secondByte << 8 | firstByte) & 0xFFFFFFFFL;
        return anUnsignedInt;
    }

    private static void skip32(int[] key, int[] buf, boolean encrypt) {
        int k;
        int kstep;
        if (encrypt) {
            kstep = 1;
            k = 0;
        } else {
            kstep = -1;
            k = 23;
        }
        int wl = (buf[0] << 8) + buf[1];
        int wr = (buf[2] << 8) + buf[3];
        for (int i = 0; i < 12; ++i) {
            wr ^= Skip32.g(key, k, wl) ^ k;
            wl ^= Skip32.g(key, k += kstep, wr) ^ k;
            k += kstep;
        }
        buf[0] = wr >> 8;
        buf[1] = wr & 0xFF;
        buf[2] = wl >> 8;
        buf[3] = wl & 0xFF;
    }

    private static int g(int[] key, int k, int w) {
        int g1 = w >> 8 & 0xFF;
        int g2 = w & 0xFF;
        int g3 = F[g2 ^ key[4 * k % 10]] ^ g1;
        int g4 = F[g3 ^ key[(4 * k + 1) % 10]] ^ g2;
        int g5 = F[g4 ^ key[(4 * k + 2) % 10]] ^ g3;
        int g6 = F[g5 ^ key[(4 * k + 3) % 10]] ^ g4;
        return (g5 << 8) + g6;
    }
}

