/*
 * Decompiled with CFR 0.152.
 */
package net.apexes.commons.lang;

import net.apexes.commons.lang.Checks;

public final class Algorithms {
    private Algorithms() {
    }

    public static void combination(int options, int select, IntArrayConsumer consumer) {
        Checks.verifyNotNull(consumer, "consumer");
        if (options <= select) {
            throw new IllegalArgumentException("The options must greater than select.");
        }
        if (select < 1) {
            throw new IllegalArgumentException("The select must greater than 1.");
        }
        if (select == 1) {
            int i = 0;
            while (i < options) {
                if (!consumer.accept(new int[]{i++})) continue;
                return;
            }
            return;
        }
        int[] array = new int[options];
        int[] result = new int[select];
        for (int i = 0; i < select; ++i) {
            array[i] = 1;
            result[i] = i;
        }
        if (consumer.accept(result)) {
            return;
        }
        int first = 0;
        int swapIndexE = select;
        while (swapIndexE < options) {
            int swapIndexB = swapIndexE - 1;
            array[swapIndexB] = 0;
            array[swapIndexE] = 1;
            int oldSwapIndexE = swapIndexE;
            int start = 0;
            if (first != 0) {
                for (int i = first; i < swapIndexB && array[i] != 0; ++i) {
                    array[i] = 0;
                    array[start] = 1;
                    result[start] = start;
                    ++start;
                }
                if (start != 0) {
                    swapIndexE = start;
                    first = 0;
                } else {
                    first = swapIndexE++;
                    while (swapIndexE < options && array[swapIndexE] != 0) {
                        ++swapIndexE;
                    }
                }
            } else if (swapIndexB == 0) {
                first = swapIndexE++;
                while (swapIndexE < options && array[swapIndexE] != 0) {
                    ++swapIndexE;
                }
            } else {
                swapIndexE = swapIndexB;
            }
            while (start < select) {
                if (result[start] == swapIndexB) {
                    result[start] = oldSwapIndexE;
                    break;
                }
                ++start;
            }
            if (!consumer.accept(result)) continue;
            return;
        }
    }

    public static void permutation(int options, IntArrayConsumer consumer) {
        block6: {
            int[] array = new int[options];
            for (int i = 0; i < options; ++i) {
                array[i] = i;
            }
            if (consumer.accept(array)) {
                return;
            }
            int end = array.length - 1;
            do {
                int index1;
                int index2 = end;
                for (index1 = end; index1 > 0 && array[index1] <= array[index1 - 1]; --index1) {
                }
                if (index1 == 0) break block6;
                int i = index1 - 1;
                while (index2 > 0 && array[index2] <= array[i]) {
                    --index2;
                }
                int temp = array[i];
                array[i] = array[index2];
                array[index2] = temp;
                i = index1;
                for (int j = end; i < j; ++i, --j) {
                    temp = array[i];
                    array[i] = array[j];
                    array[j] = temp;
                }
            } while (!consumer.accept(array));
            return;
        }
    }

    public static interface IntArrayConsumer {
        public boolean accept(int[] var1);
    }
}

