/*
 * Decompiled with CFR 0.152.
 */
package net.apexes.commons.lang;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.apexes.commons.lang.Checks;

public final class Collects {
    private Collects() {
    }

    public static <T> List<Set<T>> splitLimit(Collection<T> srcs, int batchLimit) {
        ArrayList<Set<T>> resultList = new ArrayList<Set<T>>();
        HashSet<T> subSet = new HashSet<T>();
        for (T src : srcs) {
            subSet.add(src);
            if (subSet.size() < batchLimit) continue;
            resultList.add(subSet);
            subSet = new HashSet();
        }
        if (Checks.isNotEmpty(subSet)) {
            resultList.add(subSet);
        }
        return resultList;
    }

    public static <T> List<Set<T>> splitCount(Collection<T> srcs, int splitCount) {
        int i;
        ArrayList<Set<T>> list = new ArrayList<Set<T>>();
        int size = Math.min(srcs.size(), splitCount);
        for (i = 0; i < size; ++i) {
            list.add(new HashSet());
        }
        i = 0;
        for (T src : srcs) {
            if (i == size) {
                i = 0;
            }
            Set subSet = (Set)list.get(i);
            subSet.add(src);
            ++i;
        }
        return list;
    }

    public static <K, V> List<Map<K, V>> splitCount(Map<K, V> map, int splitCount) {
        int i;
        ArrayList<Map<K, V>> list = new ArrayList<Map<K, V>>();
        int size = Math.min(map.size(), splitCount);
        for (i = 0; i < size; ++i) {
            list.add(new LinkedHashMap());
        }
        i = 0;
        for (Map.Entry<K, V> entry : map.entrySet()) {
            if (i == size) {
                i = 0;
            }
            Map subMap = (Map)list.get(i);
            subMap.put(entry.getKey(), entry.getValue());
            ++i;
        }
        return list;
    }
}

