/*
 * Decompiled with CFR 0.152.
 */
package net.apexes.commons.lang;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;

public class Comparators {
    public static int versionCompare(String version1, String version2) {
        if (version1 == null) {
            if (version2 == null) {
                return 0;
            }
            return -1;
        }
        if (version2 == null) {
            return 1;
        }
        StringTokenizer t1 = new StringTokenizer(version1, "._");
        StringTokenizer t2 = new StringTokenizer(version2, "._");
        while (t1.hasMoreTokens()) {
            int n2;
            if (!t2.hasMoreTokens()) {
                return 1;
            }
            int n1 = Integer.parseInt(t1.nextToken());
            int d = n1 - (n2 = Integer.parseInt(t2.nextToken()));
            if (d == 0) continue;
            return d;
        }
        return t2.hasMoreTokens() ? -1 : 0;
    }

    public static <E, R> ComparatorHelper<E> orderBy(ObjectGetter<E, R> getter, Comparator<R> comparator) {
        return new ComparatorHelper<E>().orderBy(getter, comparator);
    }

    public static <E> ComparatorHelper<E> orderBy(Getter<E> getter) {
        return new ComparatorHelper<E>().orderBy(getter);
    }

    public static <E> ComparatorHelper<E> orderBy(Getter<E> getter, boolean asc) {
        return new ComparatorHelper<E>().orderBy(getter, asc);
    }

    public static <E> ComparatorHelper<E> ascBy(Getter<E> getter) {
        return Comparators.orderBy(getter, true);
    }

    public static <E> ComparatorHelper<E> descBy(Getter<E> getter) {
        return Comparators.orderBy(getter, false);
    }

    public static <E> void sort(List<E> list, Getter<E> getter) {
        Comparators.orderBy(getter).sort(list);
    }

    public static <E> void sort(List<E> list, Getter<E> getter, boolean asc) {
        Comparators.orderBy(getter, asc).sort(list);
    }

    public static <E> void sortNullLast(List<E> list, Getter<E> getter) {
        Comparators.orderBy(getter).nullLast().sort(list);
    }

    public static <E> void sortNullLast(List<E> list, Getter<E> getter, boolean asc) {
        Comparators.orderBy(getter, asc).nullLast().sort(list);
    }

    public static <E> void ascSort(List<E> list, Getter<E> getter) {
        Comparators.sort(list, getter, true);
    }

    public static <E> void descSort(List<E> list, Getter<E> getter) {
        Comparators.sort(list, getter, false);
    }

    public static <E> void ascSortNullLast(List<E> list, Getter<E> getter) {
        Comparators.sortNullLast(list, getter, true);
    }

    public static <E> void descSortNullLast(List<E> list, Getter<E> getter) {
        Comparators.sortNullLast(list, getter, false);
    }

    public static <E extends Comparable<E>> int compare(E o1, E o2) {
        return Comparators.compareNull(o1, o2, false);
    }

    public static <E extends Comparable<E>> int nullFirstCompare(E o1, E o2) {
        return Comparators.compareNull(o1, o2, false);
    }

    public static <E extends Comparable<E>> int nullLastCompare(E o1, E o2) {
        return Comparators.compareNull(o1, o2, true);
    }

    static int compareNull(Comparable o1, Comparable o2, boolean nullLast) {
        int v = Comparators.xorCompare(o1, o2, nullLast);
        if (v == 0 && o1 != null && o2 != null) {
            v = o1.compareTo(o2);
        }
        if (v == 0) {
            return 0;
        }
        return v < 0 ? -1 : 1;
    }

    static <E> int xorCompare(E o1, E o2, boolean nullLast) {
        if (o1 == null) {
            if (o2 != null) {
                return nullLast ? 1 : -1;
            }
        } else if (o2 == null) {
            return nullLast ? -1 : 1;
        }
        return 0;
    }

    public static <E> Comparator<E> nullFirstComparator(Comparator<E> comparator) {
        return Comparators.nullableComparator(comparator, false);
    }

    public static <E> Comparator<E> nullLastComparator(Comparator<E> comparator) {
        return Comparators.nullableComparator(comparator, true);
    }

    public static <E> Comparator<E> nullableComparator(Comparator<E> comparator, boolean nullLast) {
        return new NullableComparator<E>(comparator, nullLast);
    }

    public static class ComparatorHelper<E>
    implements Comparator<E> {
        private final List<Comparator<E>> comparators = new ArrayList<Comparator<E>>();
        private boolean nullLast = false;

        private ComparatorHelper() {
        }

        public <R> ComparatorHelper<E> orderBy(ObjectGetter<E, R> getter, Comparator<R> comparator) {
            this.comparators.add(new ObjectGetterComparator<E, R>(this, getter, comparator));
            return this;
        }

        public ComparatorHelper<E> orderBy(Getter<E> getter) {
            this.comparators.add(new ComparableGetterComparator<E>(this, getter));
            return this;
        }

        public ComparatorHelper<E> orderBy(Getter<E> getter, boolean asc) {
            this.comparators.add(new ComparableGetterComparator<E>(this, getter, asc));
            return this;
        }

        public ComparatorHelper<E> ascBy(Getter<E> getter) {
            return this.orderBy(getter, true);
        }

        public ComparatorHelper<E> descBy(Getter<E> getter) {
            return this.orderBy(getter, false);
        }

        public ComparatorHelper<E> nullLast() {
            this.nullLast = true;
            return this;
        }

        public void sort(List<E> list) {
            Collections.sort(list, this);
        }

        @Override
        public int compare(E o1, E o2) {
            int v;
            block1: {
                Comparator<E> comparator;
                v = Comparators.xorCompare(o1, o2, this.nullLast);
                if (v != 0) break block1;
                Iterator<Comparator<E>> iterator = this.comparators.iterator();
                while (iterator.hasNext() && (v = (comparator = iterator.next()).compare(o1, o2)) == 0) {
                }
            }
            return v;
        }
    }

    public static interface ObjectGetter<E, R> {
        public R apply(E var1);
    }

    public static interface Getter<E> {
        public Comparable<?> apply(E var1);
    }

    private static class NullableComparator<E>
    implements Comparator<E> {
        private final Comparator<E> comparator;
        private final boolean nullLast;

        NullableComparator(Comparator<E> comparator, boolean nullLast) {
            this.comparator = comparator;
            this.nullLast = nullLast;
        }

        @Override
        public int compare(E o1, E o2) {
            int v = Comparators.xorCompare(o1, o2, this.nullLast);
            if (v == 0 && o1 != null && o2 != null) {
                v = this.comparator.compare(o1, o2);
            }
            if (v == 0) {
                return 0;
            }
            return v < 0 ? -1 : 1;
        }
    }

    private static class ObjectGetterComparator<E, R>
    implements Comparator<E> {
        private final ComparatorHelper<E> helper;
        private final ObjectGetter<E, R> getter;
        private final Comparator<R> comparator;

        ObjectGetterComparator(ComparatorHelper<E> helper, ObjectGetter<E, R> getter, Comparator<R> comparator) {
            this.helper = helper;
            this.getter = getter;
            this.comparator = comparator;
        }

        @Override
        public int compare(E o1, E o2) {
            return this.compareNull(this.getter.apply(o1), this.getter.apply(o2));
        }

        private int compareNull(R o1, R o2) {
            int v = Comparators.xorCompare(o1, o2, ((ComparatorHelper)this.helper).nullLast);
            if (v == 0 && o1 != null && o2 != null) {
                v = this.comparator.compare(o1, o2);
            }
            if (v == 0) {
                return 0;
            }
            return v < 0 ? -1 : 1;
        }
    }

    private static class ComparableGetterComparator<E>
    implements Comparator<E> {
        private final ComparatorHelper<E> helper;
        private final Getter<E> getter;
        private final boolean asc;

        ComparableGetterComparator(ComparatorHelper<E> helper, Getter<E> getter) {
            this(helper, getter, true);
        }

        ComparableGetterComparator(ComparatorHelper<E> helper, Getter<E> getter, boolean asc) {
            this.helper = helper;
            this.getter = getter;
            this.asc = asc;
        }

        @Override
        public int compare(E o1, E o2) {
            Comparable<?> c1 = this.getter.apply(o1);
            Comparable<?> c2 = this.getter.apply(o2);
            int v = Comparators.compareNull(c1, c2, ((ComparatorHelper)this.helper).nullLast);
            if (this.asc) {
                return v;
            }
            return -v;
        }
    }
}

