/*
 * Decompiled with CFR 0.152.
 */
package net.apexes.commons.lang;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.apexes.commons.lang.Enume;

public class EnumeRegistry {
    private final Map<Class<? extends Enume<?>>, EnumeInfo<? extends Enume<?>>> infos = new HashMap();

    public EnumeRegistry(EnumeConfigure configure) {
        EnumeConfigurator configurator = new EnumeConfigurator(){

            @Override
            public <T extends Comparable<T>, E extends Enume<T>> TableColumnRegister enume(Class<E> enumeClass) {
                Enume.verifyEnumeClass(enumeClass);
                if (EnumeRegistry.this.infos.containsKey(enumeClass)) {
                    throw new RuntimeException("The enume already registered! " + enumeClass);
                }
                EnumeInfo info = new EnumeInfo(enumeClass);
                EnumeRegistry.this.infos.put(enumeClass, info);
                return new TableColumnRegisterImpl(info);
            }
        };
        configure.configure(configurator);
    }

    public Collection<Class<? extends Enume<?>>> getEnumeClasses() {
        return this.infos.keySet();
    }

    public Collection<EnumeInfo<? extends Enume<?>>> getEnumeInfos() {
        return this.infos.values();
    }

    public static interface EnumeConfigure {
        public void configure(EnumeConfigurator var1);
    }

    public static interface EnumeConfigurator {
        public <T extends Comparable<T>, E extends Enume<T>> TableColumnRegister enume(Class<E> var1);
    }

    public static final class EnumeInfo<E extends Enume<? extends Comparable<?>>> {
        private final Class<E> enumeClass;
        private final List<TableColumn> tableColumns;

        private EnumeInfo(Class<E> enumeClass) {
            this.enumeClass = enumeClass;
            this.tableColumns = new ArrayList<TableColumn>();
        }

        public Class<E> getEnumeClass() {
            return this.enumeClass;
        }

        public List<TableColumn> getTableColumns() {
            return Collections.unmodifiableList(this.tableColumns);
        }
    }

    public static final class TableColumn {
        private final String table;
        private final List<String> columns;

        private TableColumn(String table, String ... columns) {
            this.table = table;
            this.columns = Arrays.asList(columns);
        }

        public String getTable() {
            return this.table;
        }

        public List<String> getColumns() {
            return this.columns;
        }
    }

    private static class TableColumnRegisterImpl
    implements TableColumnRegister {
        private final EnumeInfo info;
        private String table;

        private TableColumnRegisterImpl(EnumeInfo info) {
            this.info = info;
        }

        @Override
        public ColumnRegister table(String table) {
            this.table = table;
            return this;
        }

        @Override
        public TableRegister column(String ... columns) {
            this.info.tableColumns.add(new TableColumn(this.table, columns));
            return this;
        }
    }

    public static interface TableColumnRegister
    extends ColumnRegister,
    TableRegister {
    }

    public static interface TableRegister {
        public ColumnRegister table(String var1);
    }

    public static interface ColumnRegister {
        public TableRegister column(String ... var1);
    }
}

