/*
 * Decompiled with CFR 0.152.
 */
package net.apexes.commons.lang;

import java.io.PrintWriter;
import java.io.StringWriter;

public final class Exceptions {
    private Exceptions() {
    }

    public static String toString(Throwable throwable) {
        StringWriter writer = new StringWriter();
        throwable.printStackTrace(new PrintWriter(writer));
        return ((Object)writer).toString();
    }

    public static RuntimeException rethrowCause(Throwable throwable) {
        Throwable cause = throwable;
        if (cause.getCause() != null) {
            cause = cause.getCause();
        }
        return Exceptions.rethrow(cause);
    }

    public static RuntimeException rethrow(Throwable throwable) {
        if (throwable instanceof RuntimeException) {
            throw (RuntimeException)throwable;
        }
        if (throwable instanceof Error) {
            throw (Error)throwable;
        }
        throw new UnhandledCheckedException(throwable);
    }

    static class UnhandledCheckedException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        UnhandledCheckedException(Throwable cause) {
            super(cause);
        }
    }
}

