/*
 * Decompiled with CFR 0.152.
 */
package net.apexes.commons.lang;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import net.apexes.commons.lang.Checks;

public class NamedThreadFactory
implements ThreadFactory {
    private final boolean single;
    private final String namePrefix;
    private final ThreadGroup group;
    private final AtomicInteger threadNumber = new AtomicInteger(1);

    public NamedThreadFactory(String namePrefix) {
        this(namePrefix, false);
    }

    public NamedThreadFactory(String namePrefix, boolean single) {
        Checks.verifyNotNull(namePrefix, "namePrefix");
        this.single = single;
        this.namePrefix = namePrefix;
        SecurityManager s = System.getSecurityManager();
        this.group = s != null ? s.getThreadGroup() : Thread.currentThread().getThreadGroup();
    }

    @Override
    public Thread newThread(Runnable runnable) {
        String threadName = this.single ? this.namePrefix : this.namePrefix + this.threadNumber.getAndIncrement();
        Thread thread = new Thread(this.group, runnable, threadName, 0L);
        if (thread.isDaemon()) {
            thread.setDaemon(false);
        }
        if (thread.getPriority() != 5) {
            thread.setPriority(5);
        }
        return thread;
    }

    public static ThreadFactory pool(String namePrefix) {
        return new NamedThreadFactory(namePrefix);
    }

    public static ThreadFactory single(String threadName) {
        Checks.verifyNotNull(threadName, "threadName");
        return new NamedThreadFactory(threadName, true);
    }
}

