/*
 * Decompiled with CFR 0.152.
 */
package net.apexes.commons.lang;

import java.io.Serializable;
import java.math.BigInteger;

public class NumberRangeHelper
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String REGEX = ".*[^\\d](?=(\\d+))";
    private int qty;
    private BigInteger startNum;
    private BigInteger endNum;
    private String startNo;
    private String endNo;
    private String prefixCode;
    private int numLength;

    public NumberRangeHelper() {
    }

    public NumberRangeHelper(String startRef, int qtyRef) {
        this.setReference(startRef, qtyRef);
    }

    public NumberRangeHelper(String startRef, String endRef) {
        this.setReference(startRef, endRef);
    }

    public void setReference(String startRef, int qtyRef) {
        this.qty = 0;
        this.startNum = null;
        this.endNum = null;
        this.startNo = null;
        this.endNo = null;
        this.numLength = 0;
        this.prefixCode = null;
        if (startRef != null && qtyRef > 0) {
            String num = startRef.trim().replaceAll(REGEX, "");
            try {
                int numLen = num.length();
                BigInteger startTemp = new BigInteger(num);
                BigInteger endTemp = startTemp.add(BigInteger.valueOf(qtyRef - 1));
                if (endTemp.toString().length() <= numLen) {
                    this.numLength = numLen;
                    this.prefixCode = startRef.substring(0, startRef.length() - this.numLength);
                    this.startNum = startTemp;
                    this.endNum = endTemp;
                    this.qty = qtyRef;
                    this.startNo = startRef;
                    this.endNo = String.format("%s%0" + this.numLength + "d", this.prefixCode, this.endNum);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void setReference(String startRef, String endRef) {
        this.qty = 0;
        this.startNum = null;
        this.endNum = null;
        this.startNo = null;
        this.endNo = null;
        this.numLength = 0;
        this.prefixCode = null;
        if (startRef != null && endRef != null) {
            String endPrefix;
            String startPrefix;
            String startNumStr = startRef.trim().replaceAll(REGEX, "");
            String endNumStr = endRef.trim().replaceAll(REGEX, "");
            int startNumLen = startNumStr.length();
            int endNumLen = endNumStr.length();
            if (startNumLen > 0 && startNumLen == endNumLen && (startPrefix = startRef.substring(0, startRef.length() - startNumLen)).equals(endPrefix = endRef.substring(0, endRef.length() - endNumLen))) {
                try {
                    BigInteger startTemp = new BigInteger(startNumStr);
                    BigInteger endTemp = new BigInteger(endNumStr);
                    if (startTemp.compareTo(endTemp) <= 0) {
                        this.numLength = startNumLen;
                        this.prefixCode = startRef.substring(0, startRef.length() - this.numLength);
                        this.startNum = startTemp;
                        this.endNum = endTemp;
                        this.qty = this.endNum.subtract(this.startNum).intValue() + 1;
                        this.startNo = startRef;
                        this.endNo = endRef;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public boolean isValid() {
        return this.qty > 0;
    }

    public int getQty() {
        return this.qty;
    }

    public BigInteger getStartNum() {
        return this.startNum;
    }

    public BigInteger getEndNum() {
        return this.endNum;
    }

    public String getStartNo() {
        return this.startNo;
    }

    public String getEndNo() {
        return this.endNo;
    }

    public String[] generateNumbers() {
        String[] numbers = new String[this.qty];
        if (this.qty > 0) {
            int m = this.qty - 1;
            numbers[0] = this.startNo;
            numbers[m] = this.endNo;
            for (int i = 1; i < m; ++i) {
                BigInteger tmp = this.startNum.add(BigInteger.valueOf(i));
                numbers[i] = String.format("%s%0" + this.numLength + "d", this.prefixCode, tmp);
            }
        }
        return numbers;
    }

    public String toString() {
        return "NumberRangeHelper [qty=" + this.qty + ", startNum=" + this.startNum + ", endNum=" + this.endNum + ", startNo=" + this.startNo + ", endNo=" + this.endNo + ", prefixCode=" + this.prefixCode + ", numLength=" + this.numLength + "]";
    }
}

