/*
 * Decompiled with CFR 0.152.
 */
package net.apexes.commons.lang;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public final class Streams {
    static final int BUFFER_SIZE = 8192;

    private Streams() {
    }

    public static void transfer(InputStream is, OutputStream os) throws IOException {
        Streams.transfer(is, os, null);
    }

    public static void transfer(InputStream is, OutputStream os, TransferCallback callback) throws IOException {
        byte[] buf = new byte[8192];
        if (callback == null) {
            int len;
            while ((len = is.read(buf)) > 0) {
                os.write(buf, 0, len);
            }
        } else {
            int len;
            while ((len = is.read(buf)) > 0) {
                os.write(buf, 0, len);
                callback.completed(buf, 0, len);
            }
        }
    }

    public static void transfer(File sourceFile, OutputStream targetOs, boolean snapshoot) throws Exception {
        byte[] buf = new byte[10240];
        long fileLen = sourceFile.length();
        long outLen = 0L;
        try (FileInputStream fis = new FileInputStream(sourceFile);){
            int len;
            while ((len = fis.read(buf)) != -1) {
                targetOs.write(buf, 0, len);
                if (!snapshoot || (outLen += (long)len) < fileLen) continue;
                break;
            }
        }
    }

    public static byte[] toByteArray(InputStream is) throws IOException {
        int len;
        ByteArrayOutputStream swapStream = new ByteArrayOutputStream();
        byte[] buff = new byte[10240];
        while ((len = is.read(buff)) > 0) {
            swapStream.write(buff, 0, len);
        }
        return swapStream.toByteArray();
    }

    public static String toString(InputStream is, String charsetName) throws IOException {
        return new String(Streams.toByteArray(is), charsetName);
    }

    public static interface TransferCallback {
        public void completed(byte[] var1, int var2, int var3);
    }
}

