/*
 * Decompiled with CFR 0.152.
 */
package net.apexes.commons.lang;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import net.apexes.commons.lang.Checks;
import net.apexes.commons.lang.Streams;

public final class Zips {
    public static void unzip(Path zipFile, String descDir) throws IOException {
        Path descDirFile = Paths.get(descDir, new String[0]);
        if (Files.notExists(descDirFile, new LinkOption[0])) {
            Files.createDirectory(descDirFile, new FileAttribute[0]);
        }
        try (ZipFile zip = new ZipFile(zipFile.toFile());){
            Enumeration<? extends ZipEntry> entries = zip.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                String zipEntryName = entry.getName();
                Path entryFile = Paths.get(descDir, zipEntryName);
                Path entryFileParentDir = entryFile.getParent();
                if (Files.notExists(entryFileParentDir, new LinkOption[0])) {
                    Files.createDirectory(entryFileParentDir, new FileAttribute[0]);
                }
                if (Files.isDirectory(entryFile, new LinkOption[0])) continue;
                InputStream is = zip.getInputStream(entry);
                try {
                    OutputStream os = Files.newOutputStream(entryFile, new OpenOption[0]);
                    try {
                        Streams.transfer(is, os);
                    }
                    finally {
                        if (os == null) continue;
                        os.close();
                    }
                }
                finally {
                    if (is == null) continue;
                    is.close();
                }
            }
        }
    }

    public static void toZip(OutputStream out, File ... srcs) throws Exception {
        Zips.toZip(out, false, false, srcs);
    }

    public static void toZip(OutputStream out, boolean keepStructure, File ... srcs) throws Exception {
        Zips.toZip(out, keepStructure, false, srcs);
    }

    public static void toZip(OutputStream out, boolean keepStructure, boolean snapshoot, File ... srcs) throws Exception {
        Zips.toZip(out, keepStructure, snapshoot, Arrays.asList(srcs));
    }

    public static void toZip(OutputStream out, List<File> srcs) throws Exception {
        Zips.toZip(out, false, false, srcs);
    }

    public static void toZip(OutputStream out, boolean keepStructure, List<File> srcs) throws Exception {
        Zips.toZip(out, keepStructure, false, srcs);
    }

    public static void toZip(OutputStream out, boolean keepStructure, boolean snapshoot, List<File> srcs) throws Exception {
        try (ZipOutputStream zos = new ZipOutputStream(out);){
            for (File src : srcs) {
                Zips.compress(src, zos, src.getName(), keepStructure, snapshoot);
            }
            zos.finish();
        }
    }

    private static void compress(File sourceFile, ZipOutputStream zos, String name, boolean keepStructure, boolean snapshoot) throws Exception {
        if (sourceFile.isFile()) {
            zos.putNextEntry(new ZipEntry(name));
            Streams.transfer(sourceFile, (OutputStream)zos, snapshoot);
            zos.closeEntry();
        } else {
            File[] listFiles = sourceFile.listFiles();
            if (listFiles == null || listFiles.length == 0) {
                if (keepStructure) {
                    zos.putNextEntry(new ZipEntry(name + "/"));
                    zos.closeEntry();
                }
            } else {
                for (File file : listFiles) {
                    if (keepStructure) {
                        Zips.compress(file, zos, name + "/" + file.getName(), keepStructure, snapshoot);
                        continue;
                    }
                    Zips.compress(file, zos, file.getName(), keepStructure, snapshoot);
                }
            }
        }
    }

    public static ZipCompress keepStructure(OutputStream out) {
        return new ZipCompressImpl(out, true);
    }

    public static ZipCompress notStructure(OutputStream out) {
        return new ZipCompressImpl(out, true);
    }

    private static class ZipCompressImpl
    implements ZipCompress {
        private final OutputStream out;
        private final boolean keepStructure;
        private final Map<String, File> fileMap;
        private boolean snapshoot;

        private ZipCompressImpl(OutputStream out, boolean keepStructure) {
            this.out = out;
            this.keepStructure = keepStructure;
            this.fileMap = new LinkedHashMap<String, File>();
        }

        @Override
        public ZipCompress snapshoot() {
            this.snapshoot = true;
            return this;
        }

        @Override
        public ZipCompress addFile(File ... files) {
            Checks.verifyNotEmpty(files, "files");
            return this.addFiles(Arrays.asList(files));
        }

        @Override
        public ZipCompress addFiles(List<File> files) {
            Checks.verifyNotEmpty(files, "files");
            for (File file : files) {
                if (!file.exists()) continue;
                this.fileMap.put(file.getAbsolutePath(), file);
            }
            return this;
        }

        @Override
        public void compress() throws Exception {
            Zips.toZip(this.out, this.keepStructure, this.snapshoot, new ArrayList<File>(this.fileMap.values()));
        }
    }

    public static interface ZipCompress {
        public ZipCompress snapshoot();

        public ZipCompress addFile(File ... var1);

        public ZipCompress addFiles(List<File> var1);

        public void compress() throws Exception;
    }
}

