/*
 * Decompiled with CFR 0.152.
 */
package net.arnx.jef4j;

import java.io.ObjectInputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import net.arnx.jef4j.FujitsuCharsetEncoder;
import net.arnx.jef4j.FujitsuCharsetType;
import net.arnx.jef4j.util.LongObjMap;
import net.arnx.jef4j.util.Record;

class FujitsuCharsetDecoder
extends CharsetDecoder {
    private static final byte[] ASCII_MAP;
    private static final byte[] EBCDIC_MAP;
    private static final byte[] EBCDIK_MAP;
    private static final LongObjMap<Record> JEF_MAP;
    private final FujitsuCharsetType type;
    private final byte[] map;
    private boolean shiftin = false;

    public FujitsuCharsetDecoder(Charset cs, FujitsuCharsetType type) {
        super(cs, 1.0f, 1.0f);
        this.type = type;
        switch (type) {
            case ASCII: 
            case JEF_ASCII: 
            case JEF_HD_ASCII: {
                this.map = ASCII_MAP;
                break;
            }
            case EBCDIC: 
            case JEF_EBCDIC: 
            case JEF_HD_EBCDIC: {
                this.map = EBCDIC_MAP;
                break;
            }
            case EBCDIK: 
            case JEF_EBCDIK: 
            case JEF_HD_EBCDIK: {
                this.map = EBCDIK_MAP;
                break;
            }
            default: {
                this.map = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected CoderResult decodeLoop(ByteBuffer in, CharBuffer out) {
        int mark = in.position();
        try {
            block31: {
                while (in.hasRemaining()) {
                    CoderResult coderResult;
                    int b = in.get() & 0xFF;
                    if (b == 40 || b == 56) {
                        this.shiftin = true;
                        ++mark;
                        continue;
                    }
                    if (b == 41) {
                        this.shiftin = false;
                        ++mark;
                        continue;
                    }
                    if (!this.shiftin && this.map != null) {
                        char c = (char)(this.map[b] & 0xFF);
                        if (this.map == EBCDIK_MAP && c >= '\u00c0' && c <= '\u00fe') {
                            c = (char)(c - 192 + 65377);
                        }
                        if (c == '\u00ff') {
                            coderResult = CoderResult.unmappableForLength(1);
                            return coderResult;
                        }
                        if (!out.hasRemaining()) {
                            coderResult = CoderResult.OVERFLOW;
                            return coderResult;
                        }
                        out.put(c);
                        ++mark;
                        continue;
                    }
                    if (this.type.containsJEF() && b >= 64 && b <= 254) {
                        if (!in.hasRemaining()) {
                            CoderResult c = CoderResult.UNDERFLOW;
                            return c;
                        }
                        int b2 = in.get() & 0xFF;
                        if (b == 64 && b2 == 64) {
                            out.put('\u3000');
                            mark += 2;
                            continue;
                        }
                        if (b >= 128 && b <= 160) {
                            if (b2 >= 161 && b2 <= 254) {
                                out.put((char)(57344 + (b - 128) * 94 + (b2 - 161)));
                                mark += 2;
                                continue;
                            }
                            coderResult = CoderResult.unmappableForLength(2);
                            return coderResult;
                        }
                        Record record = JEF_MAP.get(b << 8 | b2 & 0xF0);
                        int pos = b2 & 0xF;
                        if (record == null || !record.exists(pos)) {
                            CoderResult coderResult2 = CoderResult.unmappableForLength(2);
                            return coderResult2;
                        }
                        long mc = record.get(pos);
                        int base = (int)(mc & 0xFFFFFL);
                        int combi = (int)(mc >> 20 & 0xFFFFFL);
                        int baseLen = Character.isSupplementaryCodePoint(base) ? 2 : 1;
                        int combiLen = combi == 0 ? 0 : (Character.isSupplementaryCodePoint(combi) ? (this.type.useHanyoDenshi() ? 2 : 0) : 1);
                        if (out.remaining() < baseLen + combiLen) {
                            CoderResult coderResult3 = CoderResult.OVERFLOW;
                            return coderResult3;
                        }
                        if (baseLen == 2) {
                            out.put(Character.highSurrogate(base));
                            out.put(Character.lowSurrogate(base));
                        } else {
                            if (baseLen != 1) {
                                CoderResult coderResult4 = CoderResult.unmappableForLength(2);
                                return coderResult4;
                            }
                            out.put((char)base);
                        }
                        if (combiLen == 2) {
                            out.put(Character.highSurrogate(combi));
                            out.put(Character.lowSurrogate(combi));
                        } else if (combiLen == 1) {
                            out.put((char)combi);
                        }
                        mark += 2;
                        continue;
                    }
                    break block31;
                }
                return CoderResult.UNDERFLOW;
            }
            CoderResult coderResult = CoderResult.unmappableForLength(1);
            return coderResult;
        }
        finally {
            in.position(mark);
        }
    }

    @Override
    protected void implReset() {
        this.shiftin = false;
    }

    static {
        try (ObjectInputStream in = new ObjectInputStream(FujitsuCharsetEncoder.class.getResourceAsStream("FujitsuDecodeMap.dat"));){
            ASCII_MAP = (byte[])in.readObject();
            EBCDIC_MAP = (byte[])in.readObject();
            EBCDIK_MAP = (byte[])in.readObject();
            JEF_MAP = (LongObjMap)in.readObject();
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }
}

