/*
 * Decompiled with CFR 0.152.
 */
package net.arnx.jef4j;

import java.io.ObjectInputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import net.arnx.jef4j.FujitsuCharsetType;
import net.arnx.jef4j.util.LongObjMap;
import net.arnx.jef4j.util.Record;

class FujitsuCharsetEncoder
extends CharsetEncoder {
    private static final byte[] ASCII_MAP;
    private static final byte[] EBCDIC_MAP;
    private static final byte[] EBCDIK_MAP;
    private static final LongObjMap<Record> JEF_MAP;
    private final FujitsuCharsetType type;
    private final byte[] map;
    private boolean shiftin = false;

    public FujitsuCharsetEncoder(Charset cs, FujitsuCharsetType type) {
        super(cs, FujitsuCharsetEncoder.getAverageBytesPerChar(type), FujitsuCharsetEncoder.getMaxBytesPerChar(type), FujitsuCharsetEncoder.getReplacementChar(type));
        this.type = type;
        switch (type) {
            case ASCII: 
            case JEF_ASCII: 
            case JEF_HD_ASCII: {
                this.map = ASCII_MAP;
                break;
            }
            case EBCDIC: 
            case JEF_EBCDIC: 
            case JEF_HD_EBCDIC: {
                this.map = EBCDIC_MAP;
                break;
            }
            case EBCDIK: 
            case JEF_EBCDIK: 
            case JEF_HD_EBCDIK: {
                this.map = EBCDIK_MAP;
                break;
            }
            default: {
                this.map = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected CoderResult encodeLoop(CharBuffer in, ByteBuffer out) {
        int mark = in.position();
        try {
            while (in.hasRemaining()) {
                int pos;
                Record record;
                char c = in.get();
                if (c >= '\ufffe') {
                    CoderResult coderResult = CoderResult.unmappableForLength(1);
                    return coderResult;
                }
                if (c <= '\u007f' || this.map == EBCDIC_MAP && (c == '\u00a3' || c == '\u00a6' || c == '\u00ac') || this.map == EBCDIK_MAP && (c == '\u00a3' || c == '\u00ac' || c >= '\uff61' && c <= '\uff9f')) {
                    byte value;
                    if (this.map == null) {
                        CoderResult coderResult = CoderResult.unmappableForLength(1);
                        return coderResult;
                    }
                    if (this.map == EBCDIK_MAP && c >= '\uff61' && c <= '\uff9f') {
                        c = (char)(c - 65377 + 192);
                    }
                    if ((value = this.map[c]) == -1) {
                        CoderResult coderResult = CoderResult.unmappableForLength(1);
                        return coderResult;
                    }
                    if (this.shiftin) {
                        if (!out.hasRemaining()) {
                            CoderResult coderResult = CoderResult.OVERFLOW;
                            return coderResult;
                        }
                        out.put((byte)41);
                        this.shiftin = false;
                    }
                    if (!out.hasRemaining()) {
                        CoderResult coderResult = CoderResult.OVERFLOW;
                        return coderResult;
                    }
                    out.put(value);
                    ++mark;
                    continue;
                }
                if (!this.type.containsJEF()) {
                    CoderResult coderResult = CoderResult.unmappableForLength(1);
                    return coderResult;
                }
                if (c >= '\ue000' && c <= '\uec1d') {
                    out.put((byte)(128 + (c - 57344) / 94 & 0xFF));
                    out.put((byte)(161 + (c - 57344) % 94 & 0xFF));
                    ++mark;
                    continue;
                }
                int progress = 1;
                if (Character.isSurrogate(c)) {
                    if (!Character.isHighSurrogate(c)) {
                        CoderResult coderResult = CoderResult.malformedForLength(1);
                        return coderResult;
                    }
                    if (!in.hasRemaining()) {
                        CoderResult coderResult = CoderResult.UNDERFLOW;
                        return coderResult;
                    }
                    char c2 = in.get();
                    if (!Character.isLowSurrogate(c2)) {
                        CoderResult coderResult = CoderResult.malformedForLength(2);
                        return coderResult;
                    }
                    record = JEF_MAP.get(Character.toCodePoint(c, c2) & 0xFFFF0);
                    pos = c2 & 0xF;
                    ++progress;
                } else {
                    record = JEF_MAP.get(c & 0xFFF0);
                    pos = c & 0xF;
                }
                if (record == null || !record.exists(pos)) {
                    CoderResult c2 = CoderResult.unmappableForLength(1);
                    return c2;
                }
                if (in.hasRemaining()) {
                    in.mark();
                }
                if (this.map != null && !this.shiftin) {
                    if (!out.hasRemaining()) {
                        CoderResult c2 = CoderResult.OVERFLOW;
                        return c2;
                    }
                    out.put((byte)40);
                    this.shiftin = true;
                }
                if (out.remaining() < 2) {
                    CoderResult c2 = CoderResult.OVERFLOW;
                    return c2;
                }
                char mc = (char)record.get(pos);
                out.put((byte)(mc >> 8 & 0xFF));
                out.put((byte)(mc & 0xFF));
                mark += progress;
            }
            return CoderResult.UNDERFLOW;
        }
        finally {
            in.position(mark);
        }
    }

    @Override
    protected CoderResult implFlush(ByteBuffer out) {
        if (this.map != null && this.shiftin) {
            if (!out.hasRemaining()) {
                return CoderResult.OVERFLOW;
            }
            out.put((byte)40);
            this.shiftin = false;
        }
        return CoderResult.UNDERFLOW;
    }

    @Override
    protected void implReset() {
        this.shiftin = false;
    }

    private static float getAverageBytesPerChar(FujitsuCharsetType type) {
        switch (type) {
            case ASCII: 
            case EBCDIC: 
            case EBCDIK: {
                return 1.0f;
            }
        }
        return 2.0f;
    }

    private static float getMaxBytesPerChar(FujitsuCharsetType type) {
        switch (type) {
            case ASCII: 
            case EBCDIC: 
            case EBCDIK: {
                return 1.0f;
            }
            case JEF: {
                return 2.0f;
            }
        }
        return 4.0f;
    }

    private static byte[] getReplacementChar(FujitsuCharsetType type) {
        switch (type) {
            case ASCII: 
            case EBCDIC: 
            case EBCDIK: {
                return new byte[]{64};
            }
        }
        return new byte[]{64, 64};
    }

    static {
        try (ObjectInputStream in = new ObjectInputStream(FujitsuCharsetEncoder.class.getResourceAsStream("FujitsuEncodeMap.dat"));){
            ASCII_MAP = (byte[])in.readObject();
            EBCDIC_MAP = (byte[])in.readObject();
            EBCDIK_MAP = (byte[])in.readObject();
            JEF_MAP = (LongObjMap)in.readObject();
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }
}

