/*
 * Decompiled with CFR 0.152.
 */
package net.arnx.jsonic.io;

import net.arnx.jsonic.io.InputSource;

public class CharSequenceInputSource
implements InputSource {
    int lines = 1;
    int columns = 1;
    int offset = 0;
    final CharSequence cs;

    public CharSequenceInputSource(CharSequence charSequence) {
        if (charSequence == null) {
            throw new NullPointerException();
        }
        this.cs = charSequence;
    }

    public int next() {
        if (this.offset < this.cs.length()) {
            char c;
            if ((c = this.cs.charAt(this.offset++)) == '\r' || c == '\n' && this.offset > 1 && this.cs.charAt(this.offset - 2) != '\r') {
                ++this.lines;
                this.columns = 0;
            } else {
                ++this.columns;
            }
            return c;
        }
        return -1;
    }

    public void back() {
        --this.offset;
        --this.columns;
    }

    public long getLineNumber() {
        return this.lines;
    }

    public long getColumnNumber() {
        return this.columns;
    }

    public long getOffset() {
        return this.offset;
    }

    public String toString() {
        return ((Object)this.cs.subSequence(this.offset - this.columns + 1, this.offset)).toString();
    }
}

