/*
 * Decompiled with CFR 0.152.
 */
package net.arnx.jsonic;

import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import net.arnx.jsonic.Converter;
import net.arnx.jsonic.JSON;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class PropertiesConverter
implements Converter {
    public static final PropertiesConverter INSTANCE = new PropertiesConverter();

    PropertiesConverter() {
    }

    @Override
    public boolean accept(Class<?> clazz) {
        return Properties.class.isAssignableFrom(clazz);
    }

    @Override
    public Object convert(JSON.Context context, Object object, Class<?> clazz, Type type) throws Exception {
        Properties properties = (Properties)context.createInternal(clazz);
        if (object instanceof Map || object instanceof List) {
            PropertiesConverter.flattenProperties(context.getLocalCache().getCachedBuffer(), object, properties);
        } else if (object != null) {
            properties.setProperty(object.toString(), null);
        }
        return properties;
    }

    private static void flattenProperties(StringBuilder stringBuilder, Object object, Properties properties) {
        if (object instanceof Map) {
            for (Map.Entry entry : ((Map)object).entrySet()) {
                int n = stringBuilder.length();
                if (n > 0) {
                    stringBuilder.append('.');
                }
                stringBuilder.append(entry.getKey());
                PropertiesConverter.flattenProperties(stringBuilder, entry.getValue(), properties);
                stringBuilder.setLength(n);
            }
        } else if (object instanceof List) {
            List list = (List)object;
            for (int i = 0; i < list.size(); ++i) {
                int n = stringBuilder.length();
                if (n > 0) {
                    stringBuilder.append('.');
                }
                stringBuilder.append(i);
                PropertiesConverter.flattenProperties(stringBuilder, list.get(i), properties);
                stringBuilder.setLength(n);
            }
        } else {
            properties.setProperty(stringBuilder.toString(), object.toString());
        }
    }
}

