/*
 * Decompiled with CFR 0.152.
 */
package net.arnx.jsonic;

import java.io.IOException;
import net.arnx.jsonic.Formatter;
import net.arnx.jsonic.JSON;
import net.arnx.jsonic.io.OutputSource;

final class StringFormatter
implements Formatter {
    public static final StringFormatter INSTANCE = new StringFormatter();
    private static final int[] ESCAPE_CHARS = new int[128];

    StringFormatter() {
    }

    public boolean accept(Object object) {
        return object != null;
    }

    public boolean isStruct() {
        return false;
    }

    public void format(JSON.Context context, Object object, Object object2, OutputSource outputSource) throws Exception {
        StringFormatter.serialize(context, object2.toString(), outputSource);
    }

    static void serialize(JSON.Context context, String string, OutputSource outputSource) throws IOException {
        outputSource.append('\"');
        int n = 0;
        int n2 = string.length();
        for (int i = 0; i < n2; ++i) {
            char c = string.charAt(i);
            if (c < ESCAPE_CHARS.length) {
                int n3 = ESCAPE_CHARS[c];
                if (n3 == 0) continue;
                if (n3 > 0) {
                    if (n < i) {
                        outputSource.append(string, n, i);
                    }
                    outputSource.append('\\');
                    outputSource.append((char)n3);
                    n = i + 1;
                    continue;
                }
                if (n3 != -1 && (n3 != -2 || context.getMode() == JSON.Mode.STRICT)) continue;
                if (n < i) {
                    outputSource.append(string, n, i);
                }
                outputSource.append("\\u00");
                outputSource.append("0123456789ABCDEF".charAt(c / 16));
                outputSource.append("0123456789ABCDEF".charAt(c % 16));
                n = i + 1;
                continue;
            }
            if (c == '\u2028') {
                if (n < i) {
                    outputSource.append(string, n, i);
                }
                outputSource.append("\\u2028");
                n = i + 1;
                continue;
            }
            if (c != '\u2029') continue;
            if (n < i) {
                outputSource.append(string, n, i);
            }
            outputSource.append("\\u2029");
            n = i + 1;
        }
        if (n < n2) {
            outputSource.append(string, n, n2);
        }
        outputSource.append('\"');
    }

    static {
        for (int i = 0; i < 32; ++i) {
            StringFormatter.ESCAPE_CHARS[i] = -1;
        }
        StringFormatter.ESCAPE_CHARS[8] = 98;
        StringFormatter.ESCAPE_CHARS[9] = 116;
        StringFormatter.ESCAPE_CHARS[10] = 110;
        StringFormatter.ESCAPE_CHARS[12] = 102;
        StringFormatter.ESCAPE_CHARS[13] = 114;
        StringFormatter.ESCAPE_CHARS[34] = 34;
        StringFormatter.ESCAPE_CHARS[92] = 92;
        StringFormatter.ESCAPE_CHARS[60] = -2;
        StringFormatter.ESCAPE_CHARS[62] = -2;
        StringFormatter.ESCAPE_CHARS[127] = -1;
    }
}

