/*
 * Decompiled with CFR 0.152.
 */
package net.arnx.jsonic.parse;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import net.arnx.jsonic.JSONEventType;
import net.arnx.jsonic.JSONException;
import net.arnx.jsonic.io.InputSource;
import net.arnx.jsonic.util.LocalCache;

public class JSONParser {
    static final int BEFORE_ROOT = 0;
    static final int AFTER_ROOT = 1;
    static final int BEFORE_NAME = 2;
    static final int AFTER_NAME = 3;
    static final int BEFORE_VALUE = 4;
    static final int AFTER_VALUE = 5;
    private static final int[] ESCAPE_CHARS = new int[128];
    private InputSource in;
    private int maxDepth;
    private boolean interpretterMode;
    private boolean ignoreWhirespace;
    private LocalCache cache;
    private int state = 0;
    private List<JSONEventType> stack = new ArrayList<JSONEventType>();
    private JSONEventType type;
    private Object value;
    private boolean first;
    private boolean active;

    public JSONParser(InputSource inputSource, int n, boolean bl, boolean bl2, LocalCache localCache) {
        this.in = inputSource;
        this.maxDepth = n;
        this.interpretterMode = bl;
        this.ignoreWhirespace = bl2;
        this.cache = localCache;
        this.active = this.stack.size() < n;
    }

    public int getMaxDepth() {
        return this.maxDepth;
    }

    public boolean isInterpretterMode() {
        return this.interpretterMode;
    }

    public boolean isIgnoreWhitespace() {
        return this.ignoreWhirespace;
    }

    public Object getValue() {
        return this.value;
    }

    public int getDepth() {
        if (this.type == JSONEventType.START_OBJECT || this.type == JSONEventType.START_ARRAY) {
            return this.stack.size();
        }
        return this.stack.size() + 1;
    }

    public JSONEventType next() throws IOException {
        JSONEventType jSONEventType = null;
        do {
            this.set(null, null, false);
            switch (this.state) {
                case 0: {
                    this.state = this.beforeRoot();
                    break;
                }
                case 1: {
                    this.state = this.afterRoot();
                    break;
                }
                case 2: {
                    this.state = this.beforeName();
                    break;
                }
                case 3: {
                    this.state = this.afterName();
                    break;
                }
                case 4: {
                    this.state = this.beforeValue();
                    break;
                }
                case 5: {
                    this.state = this.afterValue();
                }
            }
            if (this.getDepth() > this.getMaxDepth()) continue;
            jSONEventType = this.getType();
        } while (this.state != -1 && jSONEventType == null);
        return jSONEventType;
    }

    int beforeRoot() throws IOException {
        int n = this.in.next();
        if (n == 65279) {
            n = this.in.next();
        }
        switch (n) {
            case 9: 
            case 10: 
            case 13: 
            case 32: {
                this.in.back();
                String string = this.parseWhitespace();
                if (!this.isIgnoreWhitespace()) {
                    this.set(JSONEventType.WHITESPACE, string, false);
                }
                return 0;
            }
            case 123: {
                this.push(JSONEventType.START_OBJECT);
                return 2;
            }
            case 91: {
                this.push(JSONEventType.START_ARRAY);
                return 4;
            }
            case -1: {
                if (this.isInterpretterMode()) {
                    return -1;
                }
                throw this.createParseException(this.in, "json.parse.EmptyInputError");
            }
        }
        throw this.createParseException(this.in, "json.parse.UnexpectedChar", Character.valueOf((char)n));
    }

    int afterRoot() throws IOException {
        int n = this.in.next();
        switch (n) {
            case 9: 
            case 10: 
            case 13: 
            case 32: {
                this.in.back();
                String string = this.parseWhitespace();
                if (!this.isIgnoreWhitespace()) {
                    this.set(JSONEventType.WHITESPACE, string, false);
                }
                return 1;
            }
            case -1: {
                return -1;
            }
            case 91: 
            case 123: {
                if (!this.isInterpretterMode()) break;
                this.in.back();
                return 0;
            }
        }
        throw this.createParseException(this.in, "json.parse.UnexpectedChar", Character.valueOf((char)n));
    }

    int beforeName() throws IOException {
        int n = this.in.next();
        switch (n) {
            case 9: 
            case 10: 
            case 13: 
            case 32: {
                this.in.back();
                String string = this.parseWhitespace();
                if (!this.isIgnoreWhitespace()) {
                    this.set(JSONEventType.WHITESPACE, string, false);
                }
                return 2;
            }
            case 34: {
                this.in.back();
                this.set(JSONEventType.NAME, this.parseString(false), false);
                return 3;
            }
            case 125: {
                if (this.isFirst() && this.getBeginType() == JSONEventType.START_OBJECT) {
                    this.pop();
                    if (this.getBeginType() == null) {
                        return 1;
                    }
                    return 5;
                }
                throw this.createParseException(this.in, "json.parse.UnexpectedChar", Character.valueOf((char)n));
            }
            case -1: {
                throw this.createParseException(this.in, "json.parse.ObjectNotClosedError");
            }
        }
        throw this.createParseException(this.in, "json.parse.UnexpectedChar", Character.valueOf((char)n));
    }

    int afterName() throws IOException {
        int n = this.in.next();
        switch (n) {
            case 9: 
            case 10: 
            case 13: 
            case 32: {
                this.in.back();
                String string = this.parseWhitespace();
                if (!this.isIgnoreWhitespace()) {
                    this.set(JSONEventType.WHITESPACE, string, false);
                }
                return 3;
            }
            case 58: {
                return 4;
            }
            case -1: {
                throw this.createParseException(this.in, "json.parse.ObjectNotClosedError");
            }
        }
        throw this.createParseException(this.in, "json.parse.UnexpectedChar", Character.valueOf((char)n));
    }

    int beforeValue() throws IOException {
        int n = this.in.next();
        switch (n) {
            case 9: 
            case 10: 
            case 13: 
            case 32: {
                this.in.back();
                String string = this.parseWhitespace();
                if (!this.isIgnoreWhitespace()) {
                    this.set(JSONEventType.WHITESPACE, string, false);
                }
                return 4;
            }
            case 123: {
                this.push(JSONEventType.START_OBJECT);
                return 2;
            }
            case 91: {
                this.push(JSONEventType.START_ARRAY);
                return 4;
            }
            case 34: {
                this.in.back();
                this.set(JSONEventType.STRING, this.parseString(false), true);
                return 5;
            }
            case 45: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                this.in.back();
                this.set(JSONEventType.NUMBER, this.parseNumber(), true);
                return 5;
            }
            case 116: {
                this.in.back();
                this.set(JSONEventType.BOOLEAN, this.parseLiteral("true", Boolean.TRUE), true);
                return 5;
            }
            case 102: {
                this.in.back();
                this.set(JSONEventType.BOOLEAN, this.parseLiteral("false", Boolean.FALSE), true);
                return 5;
            }
            case 110: {
                this.in.back();
                this.set(JSONEventType.NULL, this.parseLiteral("null", null), true);
                return 5;
            }
            case 93: {
                if (this.isFirst() && this.getBeginType() == JSONEventType.START_ARRAY) {
                    this.pop();
                    if (this.getBeginType() == null) {
                        return 1;
                    }
                    return 5;
                }
                throw this.createParseException(this.in, "json.parse.UnexpectedChar", Character.valueOf((char)n));
            }
            case -1: {
                if (this.getBeginType() == JSONEventType.START_OBJECT) {
                    throw this.createParseException(this.in, "json.parse.ObjectNotClosedError");
                }
                if (this.getBeginType() == JSONEventType.START_ARRAY) {
                    throw this.createParseException(this.in, "json.parse.ArrayNotClosedError");
                }
                throw new IllegalStateException();
            }
        }
        throw this.createParseException(this.in, "json.parse.UnexpectedChar", Character.valueOf((char)n));
    }

    int afterValue() throws IOException {
        int n = this.in.next();
        switch (n) {
            case 9: 
            case 10: 
            case 13: 
            case 32: {
                this.in.back();
                String string = this.parseWhitespace();
                if (!this.isIgnoreWhitespace()) {
                    this.set(JSONEventType.WHITESPACE, string, false);
                }
                return 5;
            }
            case 44: {
                if (this.getBeginType() == JSONEventType.START_OBJECT) {
                    return 2;
                }
                if (this.getBeginType() == JSONEventType.START_ARRAY) {
                    return 4;
                }
                throw this.createParseException(this.in, "json.parse.UnexpectedChar", Character.valueOf((char)n));
            }
            case 125: {
                if (this.getBeginType() == JSONEventType.START_OBJECT) {
                    this.pop();
                    if (this.getBeginType() == null) {
                        return 1;
                    }
                    return 5;
                }
                throw this.createParseException(this.in, "json.parse.UnexpectedChar", Character.valueOf((char)n));
            }
            case 93: {
                if (this.getBeginType() == JSONEventType.START_ARRAY) {
                    this.pop();
                    if (this.getBeginType() == null) {
                        return 1;
                    }
                    return 5;
                }
                throw this.createParseException(this.in, "json.parse.UnexpectedChar", Character.valueOf((char)n));
            }
            case -1: {
                if (this.getBeginType() == JSONEventType.START_OBJECT) {
                    throw this.createParseException(this.in, "json.parse.ObjectNotClosedError");
                }
                if (this.getBeginType() == JSONEventType.START_ARRAY) {
                    throw this.createParseException(this.in, "json.parse.ArrayNotClosedError");
                }
                throw new IllegalStateException();
            }
        }
        throw this.createParseException(this.in, "json.parse.UnexpectedChar", Character.valueOf((char)n));
    }

    void push(JSONEventType jSONEventType) {
        this.type = jSONEventType;
        this.stack.add(jSONEventType);
        this.first = true;
        this.active = this.stack.size() < this.maxDepth;
    }

    void set(JSONEventType jSONEventType, Object object, boolean bl) {
        this.type = jSONEventType;
        this.value = object;
        if (bl) {
            this.first = false;
        }
    }

    void pop() {
        JSONEventType jSONEventType = this.stack.remove(this.stack.size() - 1);
        if (jSONEventType == JSONEventType.START_OBJECT) {
            this.type = JSONEventType.END_OBJECT;
        } else if (jSONEventType == JSONEventType.START_ARRAY) {
            this.type = JSONEventType.END_ARRAY;
        } else {
            throw new IllegalStateException();
        }
        this.first = false;
        this.active = this.stack.size() < this.maxDepth;
    }

    JSONEventType getBeginType() {
        return !this.stack.isEmpty() ? this.stack.get(this.stack.size() - 1) : null;
    }

    JSONEventType getType() {
        return this.type;
    }

    boolean isFirst() {
        return this.first;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    Object parseString(boolean bl) throws IOException {
        StringBuilder stringBuilder = this.active ? this.cache.getCachedBuffer() : null;
        int n = this.in.next();
        int n2 = this.in.mark();
        int n3 = 0;
        int n4 = -1;
        while ((n4 = this.in.next()) != -1) {
            --n2;
            ++n3;
            if (n4 < ESCAPE_CHARS.length) {
                int n5 = ESCAPE_CHARS[n4];
                if (n5 == 0) {
                    if (n2 == 0 && stringBuilder != null) {
                        this.in.copy(stringBuilder, n3);
                    }
                } else if (n5 == 1) {
                    if (n4 == n) {
                        if (n3 <= 1 || stringBuilder == null) break;
                        this.in.copy(stringBuilder, n3 - 1);
                        break;
                    }
                    if (n2 == 0 && stringBuilder != null) {
                        this.in.copy(stringBuilder, n3);
                    }
                } else if (n5 == 2) {
                    if (n3 > 0 && stringBuilder != null) {
                        this.in.copy(stringBuilder, n3 - 1);
                    }
                    n2 = 0;
                    this.in.back();
                    char c = this.parseEscape();
                    if (stringBuilder != null) {
                        stringBuilder.append(c);
                    }
                } else {
                    if (!bl) throw this.createParseException(this.in, "json.parse.UnexpectedChar", Character.valueOf((char)n4));
                    if (n2 == 0 && stringBuilder != null) {
                        this.in.copy(stringBuilder, n3);
                    }
                }
            } else if (n2 == 0 && stringBuilder != null) {
                this.in.copy(stringBuilder, n3);
            }
            if (n2 != 0) continue;
            n2 = this.in.mark();
            n3 = 0;
        }
        if (n4 != n) {
            throw this.createParseException(this.in, "json.parse.StringNotClosedError");
        }
        if (stringBuilder == null) return null;
        String string = this.cache.getString(stringBuilder);
        return string;
    }

    char parseEscape() throws IOException {
        int n = 1;
        int n2 = 0;
        int n3 = this.in.next();
        block8: while ((n3 = this.in.next()) != -1) {
            int n4;
            char c = (char)n3;
            if (n == 1) {
                switch (c) {
                    case 'b': {
                        n2 = 8;
                        break;
                    }
                    case 'f': {
                        n2 = 12;
                        break;
                    }
                    case 'n': {
                        n2 = 10;
                        break;
                    }
                    case 'r': {
                        n2 = 13;
                        break;
                    }
                    case 't': {
                        n2 = 9;
                        break;
                    }
                    case 'u': {
                        n = 2;
                        continue block8;
                    }
                    default: {
                        n2 = c;
                        break;
                    }
                }
                break;
            }
            int n5 = c >= '0' && c <= '9' ? c - 48 : (c >= 'A' && c <= 'F' ? c - 65 + 10 : (n4 = c >= 'a' && c <= 'f' ? c - 97 + 10 : -1));
            if (n4 != -1) {
                n2 = (char)(n2 | n4 << (5 - n) * 4);
                if (n == 5) break;
                ++n;
                continue;
            }
            throw this.createParseException(this.in, "json.parse.IllegalUnicodeEscape", Character.valueOf(c));
        }
        return (char)n2;
    }

    Object parseNumber() throws IOException {
        int n;
        int n2 = 0;
        StringBuilder stringBuilder = this.active ? this.cache.getCachedBuffer() : null;
        int n3 = -1;
        int n4 = -1;
        int n5 = -1;
        int n6 = this.in.mark();
        int n7 = 0;
        int n8 = 0;
        block7: while ((n5 = this.in.next()) != -1) {
            --n6;
            ++n7;
            ++n8;
            n = n5;
            switch (n) {
                case 43: {
                    if (n2 == 7) {
                        if (n6 == 0 && stringBuilder != null) {
                            this.in.copy(stringBuilder, n7);
                        }
                        n2 = 8;
                        break;
                    }
                    throw this.createParseException(this.in, "json.parse.UnexpectedChar", Character.valueOf((char)n));
                }
                case 45: {
                    if (n2 == 0) {
                        if (n6 == 0 && stringBuilder != null) {
                            this.in.copy(stringBuilder, n7);
                        }
                        n2 = 1;
                        break;
                    }
                    if (n2 == 7) {
                        if (n6 == 0 && stringBuilder != null) {
                            this.in.copy(stringBuilder, n7);
                        }
                        n2 = 8;
                        break;
                    }
                    throw this.createParseException(this.in, "json.parse.UnexpectedChar", Character.valueOf((char)n));
                }
                case 46: {
                    if (n2 == 2 || n2 == 3) {
                        if (n6 == 0 && stringBuilder != null) {
                            this.in.copy(stringBuilder, n7);
                        }
                        n2 = 4;
                        n3 = n8 - 1;
                        break;
                    }
                    throw this.createParseException(this.in, "json.parse.UnexpectedChar", Character.valueOf((char)n));
                }
                case 69: 
                case 101: {
                    if (n2 == 2 || n2 == 3 || n2 == 5 || n2 == 6) {
                        if (n6 == 0 && stringBuilder != null) {
                            this.in.copy(stringBuilder, n7);
                        }
                        n2 = 7;
                        n4 = n8 - 1;
                        break;
                    }
                    throw this.createParseException(this.in, "json.parse.UnexpectedChar", Character.valueOf((char)n));
                }
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    if (n2 == 0 || n2 == 1) {
                        if (n6 == 0 && stringBuilder != null) {
                            this.in.copy(stringBuilder, n7);
                        }
                        n2 = n == 48 ? 3 : 2;
                        break;
                    }
                    if (n2 == 2 || n2 == 5 || n2 == 9) {
                        if (n6 != 0 || stringBuilder == null) break;
                        this.in.copy(stringBuilder, n7);
                        break;
                    }
                    if (n2 == 4) {
                        if (n6 == 0 && stringBuilder != null) {
                            this.in.copy(stringBuilder, n7);
                        }
                        n2 = 5;
                        break;
                    }
                    if (n2 == 7 || n2 == 8) {
                        if (n6 == 0 && stringBuilder != null) {
                            this.in.copy(stringBuilder, n7);
                        }
                        n2 = 9;
                        break;
                    }
                    throw this.createParseException(this.in, "json.parse.UnexpectedChar", Character.valueOf((char)n));
                }
                default: {
                    if (n2 == 2 || n2 == 3 || n2 == 5 || n2 == 6 || n2 == 9) {
                        if (n7 > 1 && stringBuilder != null) {
                            this.in.copy(stringBuilder, n7 - 1);
                        }
                        this.in.back();
                        break block7;
                    }
                    throw this.createParseException(this.in, "json.parse.UnexpectedChar", Character.valueOf((char)n));
                }
            }
            if (n6 != 0) continue;
            n6 = this.in.mark();
            n7 = 0;
        }
        if (stringBuilder != null) {
            if (n3 == -1 && n4 == -1) {
                int n9 = n = stringBuilder.charAt(0) == '-' ? 1 : 0;
                if (stringBuilder.length() == n + '\u0001') {
                    long l = stringBuilder.charAt(n) - 48;
                    if (stringBuilder.charAt(0) == '-') {
                        l *= -1L;
                    }
                    return BigDecimal.valueOf(l);
                }
                if (stringBuilder.length() < n + 19) {
                    long l = 0L;
                    for (int i = n; i < stringBuilder.length(); ++i) {
                        l = l * 10L + (long)(stringBuilder.charAt(i) - 48);
                    }
                    if (stringBuilder.charAt(0) == '-') {
                        l *= -1L;
                    }
                    return BigDecimal.valueOf(l);
                }
            } else {
                int n10;
                n = stringBuilder.charAt(0) == '-' ? 1 : 0;
                int n11 = n10 = n4 >= 0 ? n4 : stringBuilder.length();
                if (n10 < n + 19) {
                    int n12;
                    long l = 0L;
                    for (n12 = n; n12 < n10; ++n12) {
                        if (n12 == n3) continue;
                        l = l * 10L + (long)(stringBuilder.charAt(n12) - 48);
                    }
                    if (stringBuilder.charAt(0) == '-') {
                        l *= -1L;
                    }
                    n12 = 0;
                    if (n4 >= 0) {
                        int n13;
                        for (int i = n13 = stringBuilder.charAt(n4 + 1) == '+' || stringBuilder.charAt(n4 + 1) == '-' ? n4 + 2 : n4 + 1; i < stringBuilder.length(); ++i) {
                            n12 = n12 * 10 + (stringBuilder.charAt(i) - 48);
                        }
                        if (stringBuilder.charAt(n4 + 1) == '-') {
                            n12 *= -1;
                        }
                    }
                    if (n3 >= 0) {
                        n12 -= n10 - (n3 + '\u0001');
                    }
                    return BigDecimal.valueOf(l, -n12);
                }
            }
            return new BigDecimal(stringBuilder.toString());
        }
        return null;
    }

    Object parseLiteral(String string, Object object) throws IOException {
        int n = 0;
        int n2 = -1;
        while ((n2 = this.in.next()) != -1) {
            char c = (char)n2;
            if (n >= string.length() || c != string.charAt(n++)) break;
            if (n != string.length()) continue;
            return this.stack.size() < this.maxDepth ? object : null;
        }
        throw this.createParseException(this.in, "json.parse.UnrecognizedLiteral", string.substring(0, n));
    }

    Object parseLiteral(boolean bl) throws IOException {
        String string;
        boolean bl2 = false;
        StringBuilder stringBuilder = this.active ? this.cache.getCachedBuffer() : null;
        int n = -1;
        while ((n = this.in.next()) != -1) {
            if (n == 92) {
                this.in.back();
                n = this.parseEscape();
            }
            if (!bl2) {
                if (Character.isJavaIdentifierStart(n)) {
                    if (!(this.active || n != 110 && n != 116 && n != 102 || stringBuilder == null)) {
                        stringBuilder = this.cache.getCachedBuffer();
                    }
                    if (stringBuilder != null) {
                        stringBuilder.append((char)n);
                    }
                    bl2 = true;
                    continue;
                }
                throw this.createParseException(this.in, "json.parse.UnexpectedChar", Character.valueOf((char)n));
            }
            if (bl2 && (Character.isJavaIdentifierPart(n) || n == 46)) {
                if (!this.active && stringBuilder != null && stringBuilder.length() == 5) {
                    stringBuilder = null;
                }
                if (stringBuilder == null) continue;
                stringBuilder.append((char)n);
                continue;
            }
            this.in.back();
            break;
        }
        String string2 = string = stringBuilder != null ? this.cache.getString(stringBuilder) : null;
        if (bl && string != null) {
            if ("null".equals(string)) {
                this.type = JSONEventType.NULL;
                return null;
            }
            if ("true".equals(string)) {
                this.type = JSONEventType.BOOLEAN;
                return this.active ? Boolean.TRUE : null;
            }
            if ("false".equals(string)) {
                this.type = JSONEventType.BOOLEAN;
                return this.active ? Boolean.FALSE : null;
            }
        }
        this.type = JSONEventType.STRING;
        return this.active ? string : null;
    }

    String parseComment() throws IOException {
        int n = 0;
        StringBuilder stringBuilder = !this.isIgnoreWhitespace() ? this.cache.getCachedBuffer() : null;
        int n2 = -1;
        int n3 = this.in.mark();
        int n4 = 0;
        block5: while ((n2 = this.in.next()) != -1) {
            --n3;
            ++n4;
            switch (n2) {
                case 47: {
                    if (n == 0) {
                        if (n3 == 0 && stringBuilder != null) {
                            this.in.copy(stringBuilder, n4);
                        }
                        n = 1;
                        break;
                    }
                    if (n == 1) {
                        if (n3 == 0 && stringBuilder != null) {
                            this.in.copy(stringBuilder, n4);
                        }
                        n = 4;
                        break;
                    }
                    if (n == 3) {
                        if (n4 <= 1 || stringBuilder == null) break block5;
                        this.in.copy(stringBuilder, n4);
                        break block5;
                    }
                    if (n == 2 || n == 4) {
                        if (n3 != 0 || stringBuilder == null) break;
                        this.in.copy(stringBuilder, n4);
                        break;
                    }
                    throw this.createParseException(this.in, "json.parse.UnexpectedChar", Character.valueOf((char)n2));
                }
                case 42: {
                    if (n == 1) {
                        if (n3 == 0 && stringBuilder != null) {
                            this.in.copy(stringBuilder, n4);
                        }
                        n = 2;
                        break;
                    }
                    if (n == 2) {
                        if (n3 == 0 && stringBuilder != null) {
                            this.in.copy(stringBuilder, n4);
                        }
                        n = 3;
                        break;
                    }
                    if (n == 3 || n == 4) {
                        if (n3 != 0 || stringBuilder == null) break;
                        this.in.copy(stringBuilder, n4);
                        break;
                    }
                    throw this.createParseException(this.in, "json.parse.UnexpectedChar", Character.valueOf((char)n2));
                }
                case 10: 
                case 13: {
                    if (n == 2 || n == 3) {
                        if (n3 == 0 && stringBuilder != null) {
                            this.in.copy(stringBuilder, n4);
                        }
                        n = 2;
                        break;
                    }
                    if (n == 4) {
                        if (n2 == 13) {
                            n2 = this.in.next();
                            this.in.back();
                            if (n2 == 10) {
                                if (n3 != 0 || stringBuilder == null) break;
                                this.in.copy(stringBuilder, n4);
                                break;
                            }
                        }
                        if (n4 <= 1 || stringBuilder == null) break block5;
                        this.in.copy(stringBuilder, n4);
                        break block5;
                    }
                    throw this.createParseException(this.in, "json.parse.UnexpectedChar", Character.valueOf((char)n2));
                }
                default: {
                    if (n == 3) {
                        if (n3 == 0 && stringBuilder != null) {
                            this.in.copy(stringBuilder, n4);
                        }
                        n = 2;
                        break;
                    }
                    if (n == 2 || n == 4) {
                        if (n3 != 0 || stringBuilder == null) break;
                        this.in.copy(stringBuilder, n4);
                        break;
                    }
                    throw this.createParseException(this.in, "json.parse.UnexpectedChar", Character.valueOf((char)n2));
                }
            }
            if (n3 != 0) continue;
            n3 = this.in.mark();
            n4 = 0;
        }
        return stringBuilder != null ? this.cache.getString(stringBuilder) : null;
    }

    String parseWhitespace() throws IOException {
        StringBuilder stringBuilder = !this.isIgnoreWhitespace() ? this.cache.getCachedBuffer() : null;
        int n = -1;
        int n2 = this.in.mark();
        int n3 = 0;
        while ((n = this.in.next()) != -1) {
            --n2;
            ++n3;
            if (n == 32 || n == 9 || n == 13 || n == 10) {
                if (n2 == 0 && stringBuilder != null) {
                    this.in.copy(stringBuilder, n3);
                }
            } else {
                if (n3 > 1 && stringBuilder != null) {
                    this.in.copy(stringBuilder, n3 - 1);
                }
                this.in.back();
                break;
            }
            if (n2 != 0) continue;
            n2 = this.in.mark();
            n3 = 0;
        }
        return stringBuilder != null ? this.cache.getString(stringBuilder) : null;
    }

    JSONException createParseException(InputSource inputSource, String string) {
        return this.createParseException(inputSource, string, null);
    }

    JSONException createParseException(InputSource inputSource, String string, Object ... objectArray) {
        String string2 = this.cache.getMessage(string, objectArray);
        return new JSONException("" + inputSource.getLineNumber() + ": " + string2 + "\n" + inputSource.toString() + " <- ?", 200, inputSource.getLineNumber(), inputSource.getColumnNumber(), inputSource.getOffset());
    }

    static {
        for (int i = 0; i < 32; ++i) {
            JSONParser.ESCAPE_CHARS[i] = 3;
        }
        JSONParser.ESCAPE_CHARS[34] = 1;
        JSONParser.ESCAPE_CHARS[39] = 1;
        JSONParser.ESCAPE_CHARS[92] = 2;
        JSONParser.ESCAPE_CHARS[127] = 3;
    }
}

