/*
 * Decompiled with CFR 0.152.
 */
package net.as_development.asdk.ssh;

import com.jcraft.jsch.JSch;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.UserInfo;
import java.io.File;
import java.io.OutputStream;
import net.as_development.asdk.ssh.SSHIdentity;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;

public class SSHConnection {
    public static final int DEFAULT_PORT = 22;
    public static final int DEFAULT_CONNECTION_TIMEOUT = 300000;
    private String m_sHost = null;
    private int m_nPort = 22;
    private File m_aKnownHosts = null;
    private SSHIdentity m_aIdentity = null;
    private JSch m_aSSHImpl = null;
    private Session m_aConnection = null;

    public void setHost(String sHost) throws Exception {
        this.m_sHost = sHost;
    }

    public void setPort(int nPort) throws Exception {
        this.m_nPort = nPort;
    }

    public void setIdentity(SSHIdentity aIdentity) throws Exception {
        this.m_aIdentity = aIdentity;
    }

    public void setKnownHostsFile(String sFile) throws Exception {
        File aKnownHosts = new File(sFile);
        if (!aKnownHosts.isFile()) {
            throw new IllegalArgumentException("Known hosts file is not a valid file.");
        }
        this.m_aKnownHosts = aKnownHosts;
    }

    public SSHIdentity getIdentity() throws Exception {
        return this.m_aIdentity;
    }

    public void connect() throws Exception {
        this.connect(300000);
    }

    public void connect(int nTimeout) throws Exception {
        if (this.m_aConnection != null) {
            return;
        }
        JSch aSSH = this.mem_SSHImpl();
        aSSH.setKnownHosts(this.mem_KnownHostsFile().getAbsolutePath());
        String sUser = this.m_aIdentity.getUser();
        String sPassphrase = this.m_aIdentity.getPassphrase();
        String sKeyFile = this.m_aIdentity.getKeyFileName();
        String sHost = this.m_sHost;
        int nPort = this.m_nPort;
        if (!StringUtils.isEmpty((CharSequence)sKeyFile)) {
            aSSH.addIdentity(sKeyFile, sPassphrase);
        }
        this.m_aConnection = aSSH.getSession(sUser, sHost, nPort);
        this.m_aConnection.setUserInfo((UserInfo)this.m_aIdentity);
        boolean bKnownHostsHandlingEnabled = this.m_aKnownHosts != null;
        String sOptionOn = bKnownHostsHandlingEnabled ? "yes" : "no";
        this.m_aConnection.setConfig("HashKnownHosts", sOptionOn);
        this.m_aConnection.setConfig("StrictHostKeyChecking", "no");
        try {
            this.m_aConnection.setOutputStream((OutputStream)System.out);
            this.m_aConnection.connect(nTimeout);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }

    public void disconnect() throws Exception {
        if (this.m_aConnection == null) {
            return;
        }
        Session aConnection = this.m_aConnection;
        this.m_aConnection = null;
        aConnection.disconnect();
    }

    public Object openChannel(String sChannel) throws Exception {
        this.connect();
        return this.m_aConnection.openChannel(sChannel);
    }

    private JSch mem_SSHImpl() throws Exception {
        if (this.m_aSSHImpl == null) {
            this.m_aSSHImpl = new JSch();
        }
        return this.m_aSSHImpl;
    }

    private File mem_KnownHostsFile() throws Exception {
        if (this.m_aKnownHosts == null) {
            String sTempDir = System.getProperty("java.io.tmpdir");
            this.m_aKnownHosts = new File(sTempDir, "known_hosts.data");
            if (!this.m_aKnownHosts.isFile()) {
                FileUtils.write((File)this.m_aKnownHosts, (CharSequence)"", (String)"utf-8");
            }
        }
        return this.m_aKnownHosts;
    }
}

