/*
 * Decompiled with CFR 0.152.
 */
package net.as_development.asdk.ssh;

import com.jcraft.jsch.UserInfo;
import java.io.File;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;

public class SSHIdentity
implements UserInfo {
    private boolean m_bNeedsSudo = false;
    private String m_sUser = null;
    private String m_sPassword = null;
    private String m_sPassphrase = null;
    private boolean m_bYes = false;
    private File m_aKeyFile = null;
    private Logger m_aLog = Logger.getLogger("global");

    public SSHIdentity() {
    }

    public SSHIdentity(String sUser, String sPassword, String sPassphrase, String sKeyFile) throws Exception {
        this.setUser(sUser);
        this.setPassword(sPassword);
        this.setPassphrase(sPassphrase);
        this.setKeyFileName(sKeyFile);
    }

    public void setNeedsSudo(boolean bNeeds) throws Exception {
        this.m_bNeedsSudo = bNeeds;
    }

    public boolean needsSudo() throws Exception {
        return this.m_bNeedsSudo;
    }

    public void setUser(String sUser) throws Exception {
        this.m_sUser = sUser;
    }

    public void setPassword(String sPassword) throws Exception {
        this.m_sPassword = sPassword;
    }

    public void setKeyFileName(String sFile) throws Exception {
        if (!StringUtils.isEmpty((CharSequence)sFile)) {
            this.m_aKeyFile = new File(sFile);
            if (!this.m_aKeyFile.isFile()) {
                throw new IllegalArgumentException("Key file seems not to be a valid file.");
            }
        }
    }

    public void setPassphrase(String sPassphrase) throws Exception {
        this.m_sPassphrase = sPassphrase;
    }

    public void sayYesToAllQuestions(boolean bYes) throws Exception {
        this.m_bYes = bYes;
    }

    public String getUser() throws Exception {
        return this.m_sUser;
    }

    public String getKeyFileName() throws Exception {
        if (this.m_aKeyFile != null) {
            return this.m_aKeyFile.getAbsolutePath();
        }
        return null;
    }

    public String getPassword() {
        return this.m_sPassword;
    }

    public String getPassphrase() {
        return this.m_sPassphrase;
    }

    public boolean promptPassword(String sMessage) {
        this.m_aLog.info("prompt passwort for: '" + sMessage + "'");
        return this.m_sPassword != null;
    }

    public boolean promptPassphrase(String sMessage) {
        this.m_aLog.info("prompt passphrase for: '" + sMessage + "'");
        return this.m_sPassphrase != null;
    }

    public boolean promptYesNo(String sMessage) {
        this.m_aLog.info("prompt yes/no for: '" + sMessage + "'");
        return this.m_bYes;
    }

    public void showMessage(String sMessage) {
        this.m_aLog.info(sMessage);
    }
}

