/*
 * Decompiled with CFR 0.152.
 */
package net.as_development.asdk.ssh;

import com.google.common.base.Predicate;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Pattern;
import net.as_development.asdk.ssh.SSHPropertiesFile;
import net.as_development.asdk.ssh.SSHSFtp;
import net.as_development.asdk.ssh.SSHServer;
import net.as_development.asdk.ssh.SSHShellExecute;
import net.as_development.asdk.ssh.SSHStdOutErrSinkV2;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.scanners.ResourcesScanner;
import org.reflections.scanners.Scanner;
import org.reflections.util.ClasspathHelper;
import org.reflections.util.ConfigurationBuilder;
import org.reflections.util.FilterBuilder;

public class SSHMacros {
    private SSHMacros() {
    }

    public static String getEnvHOME(SSHServer aServer) throws Exception {
        SSHShellExecute aShell = aServer.accessShell();
        SSHStdOutErrSinkV2 aStdOut = aServer.accessStdOutErr();
        String sCmd = "echo -n $HOME";
        aShell.execute("echo -n $HOME");
        String sHOME = aStdOut.getStdOutAndClear();
        return sHOME;
    }

    public static String getEnvTEMP(SSHServer aServer) throws Exception {
        String sTEMP = SSHMacros.readFromExec(aServer, "dirname $(mktemp -u)");
        return sTEMP;
    }

    public static String readFromExec(SSHServer aServer, String sExec) throws Exception {
        SSHShellExecute aShell = aServer.accessShell();
        SSHStdOutErrSinkV2 aStdOut = aServer.accessStdOutErr();
        String sCmd = "echo -n $(" + sExec + ")";
        aShell.execute(sCmd);
        String sResult = aStdOut.getStdOutAndClear();
        return sResult;
    }

    public static boolean existsDir(SSHServer aServer, String sRemotePath) throws Exception {
        String sResult = SSHMacros.readFromExec(aServer, "if [[ -d " + sRemotePath + " ]]; then echo 1; else echo 0; fi;");
        return StringUtils.equals((CharSequence)sResult, (CharSequence)"1");
    }

    public static int execScript(SSHServer aServer, String sRemoteScript, String ... lArguments) throws Exception {
        SSHShellExecute aShell = aServer.accessShell();
        StringBuffer sCmd = new StringBuffer(256);
        sCmd.append(sRemoteScript);
        if (lArguments != null) {
            for (String sArg : lArguments) {
                sCmd.append(" ");
                sCmd.append(sArg);
            }
        }
        int nState = aShell.execute(sCmd.toString());
        return nState;
    }

    public static int mkdir(SSHServer aServer, String sRemotePath) throws Exception {
        SSHShellExecute aShell = aServer.accessShell();
        String sCmd = "mkdir -p " + sRemotePath;
        int nState = 0;
        nState = aShell.execute(sCmd);
        return nState;
    }

    public static int touch(SSHServer aServer, String sRemotePath, String sRemoteFile) throws Exception {
        SSHShellExecute aShell = aServer.accessShell();
        String sCmd = "touch " + sRemotePath + "/" + sRemoteFile;
        int nState = 0;
        nState = aShell.execute(sCmd);
        return nState;
    }

    public static int chmod(SSHServer aServer, String sRemotePathOrFile, String sMod) throws Exception {
        SSHShellExecute aShell = aServer.accessShell();
        String sCmd = "chmod " + sMod + " " + sRemotePathOrFile;
        int nState = 0;
        nState = aShell.execute(sCmd);
        return nState;
    }

    public static int chmodRecursive(SSHServer aServer, String sRemotePath, boolean bFiles, String sPattern, String sMod) throws Exception {
        SSHShellExecute aShell = aServer.accessShell();
        StringBuffer sCmd = new StringBuffer(256);
        sCmd.append("find ");
        sCmd.append(sRemotePath);
        if (bFiles) {
            sCmd.append(" -type f");
        } else {
            sCmd.append(" -type d");
        }
        if (!StringUtils.isEmpty((CharSequence)sPattern)) {
            sCmd.append(" -name \"");
            sCmd.append(sPattern);
            sCmd.append("\"");
        }
        sCmd.append(" -print0");
        sCmd.append(" | xargs -0 chmod ");
        sCmd.append(sMod);
        int nState = aShell.execute(sCmd.toString());
        return nState;
    }

    public static int moveFile(SSHServer aServer, String sSrcPath, String sSrcFile, String sDstPath, String sDstFile) throws Exception {
        SSHShellExecute aShell = aServer.accessShell();
        StringBuffer sCmd = new StringBuffer(256);
        String sSrc = FilenameUtils.concat((String)sSrcPath, (String)sSrcFile);
        String sDst = FilenameUtils.concat((String)sDstPath, (String)sDstFile);
        sCmd.append("mv ");
        sCmd.append(sSrc);
        sCmd.append(" ");
        sCmd.append(sDst);
        int nState = aShell.execute(sCmd.toString());
        return nState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int dumpToFile(SSHServer aServer, String sRemoteFile, String sContent) throws Exception {
        String sRemotePath = FilenameUtils.getFullPathNoEndSeparator((String)sRemoteFile);
        String sRemoteFileName = FilenameUtils.getName((String)sRemoteFile);
        int nState = 0;
        nState = SSHMacros.mkdir(aServer, sRemotePath);
        if (nState != 0) {
            return nState;
        }
        SSHSFtp aUpload = aServer.accessSFTP();
        InputStream aStream = null;
        try {
            aStream = IOUtils.toInputStream((String)sContent);
            nState = aUpload.uploadStream(aStream, sRemotePath, sRemoteFileName);
        }
        finally {
            IOUtils.closeQuietly((InputStream)aStream);
        }
        return nState;
    }

    public static int uploadResourceFile(SSHServer aServer, String sResourceFile, String sRemoteFile) throws Exception {
        String sRemotePath = FilenameUtils.getFullPathNoEndSeparator((String)sRemoteFile);
        String sRemoteFileName = FilenameUtils.getName((String)sRemoteFile);
        int nState = 0;
        nState = SSHMacros.mkdir(aServer, sRemotePath);
        if (nState != 0) {
            return nState;
        }
        SSHSFtp aUpload = aServer.accessSFTP();
        Class<SSHMacros> aLoader = SSHMacros.class;
        URL aResource = aLoader.getResource(sResourceFile);
        InputStream aStream = aResource.openStream();
        nState = aUpload.uploadStream(aStream, sRemotePath, sRemoteFileName);
        return nState;
    }

    public static int uploadResourceTree(SSHServer aServer, String sResourceTree, String sRemoteTree) throws Exception {
        ByteArrayOutputStream aTarOut = new ByteArrayOutputStream();
        SSHMacros.impl_tarResourceTree(sResourceTree, aTarOut);
        ByteArrayInputStream aTarIn = new ByteArrayInputStream(aTarOut.toByteArray());
        int nState = 0;
        SSHSFtp aUpload = aServer.accessSFTP();
        nState = aUpload.uploadStream(aTarIn, sRemoteTree, "_temp.tar");
        SSHShellExecute aShell = aServer.accessShell();
        nState = aShell.execute("tar --extract --verbose --directory " + sRemoteTree + " --file " + sRemoteTree + "/_temp.tar");
        nState = aShell.execute("rm " + sRemoteTree + "/_temp.tar");
        return nState;
    }

    public static void createPropertiesFile(SSHServer aServer, String sRemotePath, String sRemoteFile, Properties lProps) throws Exception {
        SSHPropertiesFile aProps = aServer.accessProperties();
        aProps.setProperties(sRemotePath, sRemoteFile, lProps);
    }

    private static void impl_tarResourceTree(String sResourceTree, OutputStream aTarStream) throws Exception {
        String sResPackage = sResourceTree;
        String sResPath = StringUtils.replace((String)sResPackage, (String)".", (String)"/");
        Reflections aScanner = new Reflections((Configuration)new ConfigurationBuilder().setUrls(ClasspathHelper.forPackage((String)sResPackage, (ClassLoader[])new ClassLoader[0])).setScanners(new Scanner[]{new ResourcesScanner()}).filterInputsBy((Predicate)new FilterBuilder().includePackage(new String[]{sResPackage})));
        Set lAllResources = aScanner.getResources(Pattern.compile(".*"));
        Class<SSHMacros> aResLoader = SSHMacros.class;
        TarArchiveOutputStream aTar = new TarArchiveOutputStream(aTarStream);
        for (String sResource : lAllResources) {
            URL aResource = aResLoader.getResource("/" + sResource);
            InputStream aStream = aResource.openStream();
            byte[] aContent = IOUtils.toByteArray((InputStream)aStream);
            int nSize = aContent.length;
            String sName = StringUtils.removeStart((String)sResource, (String)sResPath);
            TarArchiveEntry aResEntry = new TarArchiveEntry(sName);
            aResEntry.setSize((long)nSize);
            aTar.putArchiveEntry((ArchiveEntry)aResEntry);
            aTar.write(aContent);
            aTar.closeArchiveEntry();
        }
        Validate.isTrue((aTar.getBytesWritten() > 0L ? 1 : 0) != 0, (String)"Tar has no content !", (Object[])new Object[0]);
        aTar.close();
    }
}

