/*
 * Decompiled with CFR 0.152.
 */
package net.as_development.asdk.ssh;

import com.jcraft.jsch.ChannelSftp;
import java.io.InputStream;
import net.as_development.asdk.ssh.SSHConnection;
import net.as_development.asdk.ssh.SSHIdentity;
import net.as_development.asdk.ssh.SSHMacros;
import net.as_development.asdk.ssh.SSHServer;
import org.apache.commons.io.FilenameUtils;

public class SSHSFtp {
    private SSHServer m_aServer = null;

    public void bind(SSHServer aServer) throws Exception {
        this.m_aServer = aServer;
    }

    public int uploadStream(InputStream aStream, String sRemoteDir, String sRemoteName) throws Exception {
        SSHIdentity aIdentity = this.m_aServer.accessIdentity();
        boolean bNeedsSudo = aIdentity.needsSudo();
        if (bNeedsSudo) {
            return this.uploadStreamIndirect(aStream, sRemoteDir, sRemoteName);
        }
        return this.uploadStreamDirect(aStream, sRemoteDir, sRemoteName);
    }

    public int uploadStreamIndirect(InputStream aStream, String sRemoteDir, String sRemoteName) throws Exception {
        SSHConnection aConnection = this.m_aServer.accessConnection();
        ChannelSftp aChannel = (ChannelSftp)aConnection.openChannel("sftp");
        String sTEMP = SSHMacros.getEnvTEMP(this.m_aServer);
        String sTempDir = FilenameUtils.concat((String)sTEMP, (String)"sshsftp-temp");
        aChannel.connect();
        SSHMacros.mkdir(this.m_aServer, sTempDir);
        SSHMacros.chmod(this.m_aServer, sTempDir, "777");
        SSHMacros.touch(this.m_aServer, sTempDir, sRemoteName);
        SSHMacros.chmod(this.m_aServer, sTempDir + "/" + sRemoteName, "777");
        aChannel.cd(sTempDir);
        aChannel.put(aStream, sRemoteName);
        SSHMacros.mkdir(this.m_aServer, sRemoteDir);
        SSHMacros.moveFile(this.m_aServer, sTempDir, sRemoteName, sRemoteDir, sRemoteName);
        aChannel.disconnect();
        int nState = this.impl_getCorrectExitStatus(aChannel);
        this.m_aServer.doAutoFailIfNeeded(nState);
        return nState;
    }

    public int uploadStreamDirect(InputStream aStream, String sRemoteDir, String sRemoteName) throws Exception {
        SSHConnection aConnection = this.m_aServer.accessConnection();
        ChannelSftp aChannel = (ChannelSftp)aConnection.openChannel("sftp");
        aChannel.setPty(true);
        aChannel.connect();
        aChannel.cd(sRemoteDir);
        aChannel.put(aStream, sRemoteName);
        aChannel.disconnect();
        int nState = this.impl_getCorrectExitStatus(aChannel);
        this.m_aServer.doAutoFailIfNeeded(nState);
        return nState;
    }

    private int impl_getCorrectExitStatus(ChannelSftp aChannel) throws Exception {
        int nOrgState = aChannel.getExitStatus();
        if (nOrgState == -1) {
            return 0;
        }
        return nOrgState;
    }
}

