/*
 * Decompiled with CFR 0.152.
 */
package net.as_development.asdk.ssh;

import net.as_development.asdk.ssh.SSHConnection;
import net.as_development.asdk.ssh.SSHIdentity;
import net.as_development.asdk.ssh.SSHPropertiesFile;
import net.as_development.asdk.ssh.SSHSFtp;
import net.as_development.asdk.ssh.SSHShellExecute;
import net.as_development.asdk.ssh.SSHStdOutErrSinkV2;

public class SSHServer {
    private String m_sHost = null;
    private int m_nPort = 22;
    private String m_sRemoteWorkingPath = null;
    private SSHConnection m_aConnection = null;
    private SSHStdOutErrSinkV2 m_aStdOutErrSink = null;
    private SSHIdentity m_aIdentity = null;
    private boolean m_bFailOnErrorAutomatically = true;

    public void setHost(String sHost) throws Exception {
        this.m_sHost = sHost;
    }

    public void setPort(int nPort) throws Exception {
        this.m_nPort = nPort;
    }

    public void setIdentity(SSHIdentity aIdentity) throws Exception {
        this.m_aIdentity = aIdentity;
    }

    public void setRemoteWorkingPath(String sPath) throws Exception {
        this.m_sRemoteWorkingPath = sPath;
    }

    public String getRemoteWorkingPath() throws Exception {
        return this.m_sRemoteWorkingPath;
    }

    public boolean hasToFailOnErrorAutomatically() throws Exception {
        return this.m_bFailOnErrorAutomatically;
    }

    public void connect() throws Exception {
        this.mem_Connection().connect();
    }

    public void disconnect() throws Exception {
        this.mem_Connection().disconnect();
    }

    public SSHIdentity accessIdentity() throws Exception {
        return this.m_aIdentity;
    }

    public SSHStdOutErrSinkV2 accessStdOutErr() throws Exception {
        return this.mem_StdOutErrSink();
    }

    public SSHConnection accessConnection() throws Exception {
        return this.mem_Connection();
    }

    public SSHSFtp accessSFTP() throws Exception {
        SSHSFtp aSFTP = new SSHSFtp();
        aSFTP.bind(this);
        return aSFTP;
    }

    public SSHShellExecute accessShell() throws Exception {
        SSHShellExecute aShell = new SSHShellExecute();
        aShell.bind(this);
        return aShell;
    }

    public SSHPropertiesFile accessProperties() throws Exception {
        SSHPropertiesFile aSFTP = new SSHPropertiesFile();
        aSFTP.bind(this);
        return aSFTP;
    }

    public void doAutoFailIfNeeded(int nLastCommandResult) throws Exception {
        if (!this.m_bFailOnErrorAutomatically) {
            return;
        }
        if (nLastCommandResult != 0) {
            throw new Exception("Auto-Fail : Result of last command was " + nLastCommandResult);
        }
    }

    private SSHConnection mem_Connection() throws Exception {
        if (this.m_aConnection == null) {
            SSHConnection aConnection = new SSHConnection();
            aConnection.setHost(this.m_sHost);
            aConnection.setIdentity(this.m_aIdentity);
            aConnection.setPort(this.m_nPort);
            this.m_aConnection = aConnection;
        }
        return this.m_aConnection;
    }

    private SSHStdOutErrSinkV2 mem_StdOutErrSink() throws Exception {
        if (this.m_aStdOutErrSink == null) {
            this.m_aStdOutErrSink = new SSHStdOutErrSinkV2();
        }
        return this.m_aStdOutErrSink;
    }
}

