/*
 * Decompiled with CFR 0.152.
 */
package net.as_development.asdk.ssh;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelExec;
import net.as_development.asdk.ssh.SSHConnection;
import net.as_development.asdk.ssh.SSHIdentity;
import net.as_development.asdk.ssh.SSHServer;
import net.as_development.asdk.ssh.SSHStdOutErrSinkV2;

public class SSHShellExecute {
    private static final int POLL_TIME_4_EXECUTE = 1000;
    private SSHServer m_aServer = null;

    protected void bind(SSHServer aServer) throws Exception {
        this.m_aServer = aServer;
    }

    public int execute(String sCommand) throws Exception {
        System.out.println("exec '" + sCommand + "' ...");
        SSHConnection aConnection = this.m_aServer.accessConnection();
        SSHStdOutErrSinkV2 aStdOutErr = this.m_aServer.accessStdOutErr();
        SSHIdentity aIdentity = this.m_aServer.accessIdentity();
        boolean bNeedsSudo = aIdentity.needsSudo();
        ChannelExec aShell = (ChannelExec)aConnection.openChannel("exec");
        String sRealCmd = sCommand;
        if (bNeedsSudo) {
            sRealCmd = "sudo -i -H sh -c '" + sCommand + "'";
        }
        aStdOutErr.bind((Channel)aShell);
        aShell.setPty(true);
        aShell.setCommand(sRealCmd);
        aShell.connect();
        while (!aShell.isClosed()) {
            try {
                Thread.sleep(1000L);
            }
            catch (Exception ex) {}
        }
        int nResult = aShell.getExitStatus();
        aShell.disconnect();
        aStdOutErr.unbind();
        this.m_aServer.doAutoFailIfNeeded(nResult);
        return nResult;
    }
}

