/*
 * Decompiled with CFR 0.152.
 */
package net.as_development.asdk.ssh;

import com.jcraft.jsch.Channel;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class SSHStdOutErrSinkV1 {
    private ByteArrayOutputStream m_aStdOut = null;
    private ByteArrayOutputStream m_aStdErr = null;

    public synchronized void bind(Channel aChannel) throws Exception {
        this.m_aStdOut = new ByteArrayOutputStream();
        aChannel.setExtOutputStream((OutputStream)new LogStream(this.m_aStdOut));
    }

    public synchronized String getStdOut() throws Exception {
        if (this.m_aStdOut != null) {
            return this.m_aStdOut.toString();
        }
        return "";
    }

    public synchronized String getStdOutAndClear() throws Exception {
        String sOut = "";
        if (this.m_aStdOut != null) {
            sOut = this.m_aStdOut.toString();
            this.m_aStdOut.reset();
        }
        return sOut;
    }

    public synchronized String getStdErr() throws Exception {
        if (this.m_aStdErr != null) {
            return this.m_aStdErr.toString();
        }
        return "";
    }

    public synchronized String getStdErrAndClear() throws Exception {
        String sErr = "";
        if (this.m_aStdErr != null) {
            sErr = this.m_aStdErr.toString();
            this.m_aStdErr.reset();
        }
        return sErr;
    }

    private class LogStream
    extends OutputStream {
        public OutputStream m_aWrapStream = null;

        public LogStream(OutputStream aWrapStream) throws Exception {
            this.m_aWrapStream = aWrapStream;
        }

        @Override
        public void write(int b) throws IOException {
            this.m_aWrapStream.write(b);
            System.out.print(b);
        }
    }
}

