/*
 * Decompiled with CFR 0.152.
 */
package net.as_development.asdk.ssh;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelExec;
import java.io.InputStream;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class SSHStdOutErrSinkV2 {
    private static final int STREAM_BLOCKSIZE = 65565;
    private InputStream m_aStdOut = null;
    private InputStream m_aStdErr = null;
    private StringBuffer m_sStdOut = null;
    private StringBuffer m_sStdErr = null;
    private ExecutorService m_aAsync = null;
    private Future<?> m_aStdOutSync = null;
    private Future<?> m_aStdErrSync = null;

    public synchronized void bind(Channel aChannel) throws Exception {
        this.m_aStdOut = aChannel.getInputStream();
        if (aChannel instanceof ChannelExec) {
            this.m_aStdErr = ((ChannelExec)aChannel).getErrStream();
        }
        this.start();
    }

    public synchronized void unbind() throws Exception {
        this.stop(10000L);
        this.m_aStdOut = null;
        this.m_aStdErr = null;
    }

    public synchronized void start() throws Exception {
        if (this.m_aAsync != null) {
            return;
        }
        this.m_sStdOut = new StringBuffer(256);
        this.m_sStdErr = new StringBuffer(256);
        this.m_aAsync = Executors.newFixedThreadPool(2);
        this.m_aStdOutSync = this.impl_readStreamToBufferAsync(this.m_aStdOut, this.m_sStdOut, this.m_aAsync);
        this.m_aStdErrSync = this.impl_readStreamToBufferAsync(this.m_aStdErr, this.m_sStdErr, this.m_aAsync);
    }

    public synchronized void stop(long nTimeoutInMS) throws Exception {
        boolean bOK;
        if (this.m_aAsync == null) {
            return;
        }
        this.m_aAsync.shutdown();
        if (this.m_aStdOutSync != null) {
            this.m_aStdOutSync.cancel(true);
        }
        if (this.m_aStdErrSync != null) {
            this.m_aStdErrSync.cancel(true);
        }
        if (!(bOK = this.m_aAsync.awaitTermination(nTimeoutInMS, TimeUnit.MILLISECONDS))) {
            throw new TimeoutException("Termination of threads exceeded timeout of " + nTimeoutInMS + " ms.");
        }
        this.m_aAsync = null;
        this.m_aStdOutSync = null;
        this.m_aStdErrSync = null;
    }

    public synchronized String getStdOut() throws Exception {
        if (this.m_sStdOut != null) {
            return this.m_sStdOut.toString();
        }
        return "";
    }

    public synchronized String getStdOutAndClear() throws Exception {
        String sStdOut = "";
        if (this.m_sStdOut != null) {
            sStdOut = this.m_sStdOut.toString();
            this.m_sStdOut.setLength(0);
        }
        return sStdOut;
    }

    public synchronized String getStdErr() throws Exception {
        if (this.m_sStdErr != null) {
            return this.m_sStdErr.toString();
        }
        return "";
    }

    public synchronized String getStdErrAndClear() throws Exception {
        String sStdErr = "";
        if (this.m_sStdErr != null) {
            sStdErr = this.m_sStdErr.toString();
            this.m_sStdErr.setLength(0);
        }
        return sStdErr;
    }

    private Future<?> impl_readStreamToBufferAsync(final InputStream aStream, final StringBuffer sBuffer, ExecutorService aAsync) throws Exception {
        if (aStream == null) {
            return null;
        }
        Future<?> aSync = aAsync.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    Thread aThis = Thread.currentThread();
                    byte[] lBuffer = new byte[65565];
                    while (!aThis.isInterrupted()) {
                        int nAvailable = aStream.available();
                        if (nAvailable < 1) continue;
                        int nRead = aStream.read(lBuffer, 0, nAvailable);
                        if (nRead >= 0) {
                            String sRead = new String(lBuffer, 0, nRead);
                            sBuffer.append(sRead);
                            System.out.print(sRead);
                            continue;
                        }
                        break;
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        });
        return aSync;
    }
}

