/*
 * Decompiled with CFR 0.152.
 */
package net.atinu.dvalidation.validator;

import net.atinu.dvalidation.DomainErrors;
import net.atinu.dvalidation.ErrorMap;
import net.atinu.dvalidation.errors.package;
import net.atinu.dvalidation.errors.package$IsEmptySeqError$;
import net.atinu.dvalidation.errors.package$IsEmptyStringError$;
import net.atinu.dvalidation.errors.package$IsNoneError$;
import net.atinu.dvalidation.errors.package$IsNotEqualError$;
import net.atinu.dvalidation.errors.package$IsTryFailureError$;
import net.atinu.dvalidation.errors.package$IsZeroError$;
import net.atinu.dvalidation.package$;
import net.atinu.dvalidation.package$tToSuccess$;
import net.atinu.dvalidation.validator.BaseValidator;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Serializable;
import scala.Some;
import scala.collection.Traversable;
import scala.runtime.BoxesRunTime;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scalaz.Equal;
import scalaz.Monoid;
import scalaz.Validation;

public abstract class BaseValidator$class {
    public static Validation notBlank(BaseValidator $this, String s, boolean trimWhitespace, ErrorMap mapError) {
        String testStr = trimWhitespace ? s.trim() : s;
        return testStr.isEmpty() ? $this.failMapped(new package.IsEmptyStringError(package$IsEmptyStringError$.MODULE$.$lessinit$greater$default$1()), mapError) : package$tToSuccess$.MODULE$.valid$extension(package$.MODULE$.tToSuccess(s));
    }

    public static boolean notBlank$default$2(BaseValidator $this) {
        return true;
    }

    public static Validation notZero(BaseValidator $this, Object s, Monoid m, Equal e, ErrorMap mapError) {
        return m.isMZero(s, e) ? $this.failMapped(new package.IsZeroError(s, package$IsZeroError$.MODULE$.$lessinit$greater$default$2()), mapError) : package$tToSuccess$.MODULE$.valid$extension(package$.MODULE$.tToSuccess(s));
    }

    public static Validation hasElements(BaseValidator $this, Traversable s, ErrorMap mapError) {
        return s.isEmpty() ? $this.failMapped(new package.IsEmptySeqError(package$IsEmptySeqError$.MODULE$.$lessinit$greater$default$1()), mapError) : package$tToSuccess$.MODULE$.valid$extension(package$.MODULE$.tToSuccess(s));
    }

    public static Validation isSome(BaseValidator $this, Option s, ErrorMap mapError) {
        return s.isEmpty() ? $this.failMapped(new package.IsNoneError(package$IsNoneError$.MODULE$.$lessinit$greater$default$1()), mapError) : package$tToSuccess$.MODULE$.valid$extension(package$.MODULE$.tToSuccess(s));
    }

    public static Validation isTrySuccess(BaseValidator $this, Try s, ErrorMap mapError) {
        Try try_;
        block4: {
            Object object;
            block3: {
                block2: {
                    try_ = s;
                    if (!(try_ instanceof Success)) break block2;
                    object = package$tToSuccess$.MODULE$.valid$extension(package$.MODULE$.tToSuccess(s));
                    break block3;
                }
                if (!(try_ instanceof Failure)) break block4;
                Failure failure = (Failure)try_;
                Throwable e = failure.exception();
                object = $this.failMapped(new package.IsTryFailureError(e, package$IsTryFailureError$.MODULE$.$lessinit$greater$default$2()), mapError);
            }
            return object;
        }
        throw new MatchError((Object)try_);
    }

    public static Validation isEqual(BaseValidator $this, Object value, Object valueExpected, ErrorMap mapError) {
        return BoxesRunTime.equals((Object)value, (Object)valueExpected) ? package$tToSuccess$.MODULE$.valid$extension(package$.MODULE$.tToSuccess(value)) : $this.failMapped(new package.IsNotEqualError(value, valueExpected, package$IsNotEqualError$.MODULE$.$lessinit$greater$default$3()), mapError);
    }

    public static Validation isEqualStrict(BaseValidator $this, Object value, Object valueExpected, Equal ev, ErrorMap mapError) {
        return ev.equal(value, valueExpected) ? package$tToSuccess$.MODULE$.valid$extension(package$.MODULE$.tToSuccess(value)) : $this.failMapped(new package.IsNotEqualError(value, valueExpected, package$IsNotEqualError$.MODULE$.$lessinit$greater$default$3()), mapError);
    }

    public static Validation validOpt(BaseValidator $this, Option a, Function1 v) {
        return BaseValidator$class.validateOptBase($this, a, v, (Function0)new Serializable($this){

            public final Validation<DomainErrors, None$> apply() {
                return package$tToSuccess$.MODULE$.valid$extension(package$.MODULE$.tToSuccess(None$.MODULE$));
            }
        });
    }

    public static Validation validOptRequired(BaseValidator $this, Option a, Function1 v, ErrorMap mapError) {
        return BaseValidator$class.validateOptBase($this, a, v, (Function0)new Serializable($this, mapError){
            private final /* synthetic */ BaseValidator $outer;
            private final ErrorMap mapError$1;

            public final Validation<DomainErrors, Option<T>> apply() {
                return this.$outer.failMapped(new package.IsNoneError(package$IsNoneError$.MODULE$.$lessinit$greater$default$1()), this.mapError$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.mapError$1 = mapError$1;
            }
        });
    }

    private static Validation validateOptBase(BaseValidator $this, Option a, Function1 v, Function0 err) {
        Validation validation;
        Option option = a;
        if (option instanceof Some) {
            Some some = (Some)option;
            Object value = some.x();
            validation = ((Validation)v.apply(value)).map((Function1)new Serializable($this){

                public final Option<Object> apply(Object x) {
                    return Option$.MODULE$.apply(x);
                }
            });
        } else {
            validation = (Validation)err.apply();
        }
        return validation;
    }

    public static Validation validTry(BaseValidator $this, Try a, Function1 v, ErrorMap mapError) {
        Try try_;
        block4: {
            Validation validation;
            block3: {
                block2: {
                    try_ = a;
                    if (!(try_ instanceof Success)) break block2;
                    Success success = (Success)try_;
                    Object g = success.value();
                    validation = ((Validation)v.apply(g)).map((Function1)new Serializable($this){

                        public final Success<T> apply(T value) {
                            return new Success(value);
                        }
                    });
                    break block3;
                }
                if (!(try_ instanceof Failure)) break block4;
                Failure failure = (Failure)try_;
                Throwable e = failure.exception();
                validation = $this.failMapped(new package.IsTryFailureError(e, package$IsTryFailureError$.MODULE$.$lessinit$greater$default$2()), mapError);
            }
            return validation;
        }
        throw new MatchError((Object)try_);
    }

    public static void $init$(BaseValidator $this) {
    }
}

